# Commands covered:  pid
#
# This file contains a collection of tests for one or more of the Tcl
# built-in commands.  Sourcing this file into Tcl runs the tests and
# generates output for errors.  No output means no errors were found.
#
# Copyright (c) 1991-1993 The Regents of the University of California.
# Copyright (c) 1994-1995 Sun Microsystems, Inc.
# Copyright (c) 1998-1999 by Scriptics Corporation.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# RCS: @(#) $Id: pid.tcl,v 1.1 2006/12/29 09:02:53 fourdman Exp $

if {[lsearch [namespace children] ::tcltest] == -1} {
    package require tcltest 2
    namespace import -force ::tcltest::*
}

# If pid is not defined just return with no error
# Some platforms may not have the pid command implemented
if {[info commands pid] == ""} {
    puts "pid is not implemented for this machine"
    ::tcltest::cleanupTests
    return
}

test pid-1.1 {pid command} {
    regexp {(^[0-9]+$)|(^0x[0-9a-fA-F]+$)} [pid]
} 1
test pid-1.2 {pid command} -constraints {unixOrPc unixExecs} -setup {
    set path(test1) [makeFile {} test1]
    file delete $path(test1)
} -body {
    set f [open |[list echo foo | cat >$path(test1)] w]
    set pids [pid $f]
    close $f
    list [llength $pids] [regexp {^[0-9]+$} [lindex $pids 0]] \
       [regexp {^[0-9]+$} [lindex $pids 1]] \
       [expr {[lindex $pids 0] == [lindex $pids 1]}]
} -cleanup {
    removeFile test1
} -result {2 1 1 0}
test pid-1.3 {pid command} -setup {
    set path(test1) [makeFile {} test1]
    file delete $path(test1)
} -body {
    set f [open $path(test1) w]
    set pids [pid $f]
    close $f
    set pids
} -cleanup {
    removeFile test1
} -result {}
test pid-1.4 {pid command} {
    list [catch {pid a b} msg] $msg
} {1 {wrong # args: should be "pid ?channelId?"}}
test pid-1.5 {pid command} {
    list [catch {pid gorp} msg] $msg
} {1 {can not find channel named "gorp"}}

# cleanup
::tcltest::cleanupTests
return












