/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text.completion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.tcl.internal.ui.templates.TclTemplateCompletionProcessor;
import org.eclipse.dltk.tcl.internal.ui.text.completion.LazyTclTypeCompletionProposal;
import org.eclipse.dltk.tcl.internal.ui.text.completion.TclCompletionProposalCollector;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposalCollector;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposalComputer;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;

public class TclTypeCompletionProposalComputer
extends ScriptCompletionProposalComputer {
    private IScriptCompletionProposal createTypeProposal(int relevance, String fullyQualifiedType, ScriptContentAssistInvocationContext context) throws ModelException {
        IType type = context.getSourceModule().getScriptProject().findType(fullyQualifiedType);
        if (type == null) {
            return null;
        }
        CompletionProposal proposal = CompletionProposal.create((int)7, (int)context.getInvocationOffset());
        proposal.setCompletion(type.getElementName().toCharArray());
        proposal.setFlags(type.getFlags());
        proposal.setRelevance(relevance);
        proposal.setReplaceRange(context.getInvocationOffset(), context.getInvocationOffset());
        return new LazyTclTypeCompletionProposal(proposal, context);
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        System.out.println("TclTypeCompletionProposalComputer.computeContextInformation()");
        List types = this.computeCompletionProposals(context, monitor);
        if (DLTKCore.DEBUG) {
            System.out.println("!!! Proposals: " + types.size());
        }
        Iterator iter = types.iterator();
        ArrayList<IContextInformation> list = new ArrayList<IContextInformation>();
        while (iter.hasNext()) {
            IScriptCompletionProposal proposal = (IScriptCompletionProposal)iter.next();
            if (DLTKCore.DEBUG) {
                System.out.println("Proposal: " + proposal + ", info: " + proposal.getContextInformation().getInformationDisplayString());
            }
            list.add(proposal.getContextInformation());
        }
        return list;
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        List types = super.computeCompletionProposals(context, monitor);
        if (context instanceof ScriptContentAssistInvocationContext) {
            ScriptContentAssistInvocationContext scriptContext = (ScriptContentAssistInvocationContext)context;
            try {
                IType expectedType;
                if (types.size() > 0 && context.computeIdentifierPrefix().length() == 0 && (expectedType = scriptContext.getExpectedType()) != null) {
                    LazyTclTypeCompletionProposal typeProposal = (LazyTclTypeCompletionProposal)((Object)types.get(0));
                    List history = DLTKUIPlugin.getDefault().getContentAssistHistory().getHistory(expectedType.getFullyQualifiedName()).getTypes();
                    int relevance = typeProposal.getRelevance() - history.size() - 1;
                    Iterator it = history.iterator();
                    while (it.hasNext()) {
                        String type = (String)it.next();
                        if (type.equals(((IType)typeProposal.getModelElement()).getFullyQualifiedName())) continue;
                        IScriptCompletionProposal proposal = this.createTypeProposal(relevance, type, scriptContext);
                        if (proposal != null) {
                            types.add(proposal);
                        }
                        ++relevance;
                    }
                }
            }
            catch (BadLocationException x) {
                DLTKUIPlugin.log((Throwable)x);
            }
            catch (ModelException x) {
                DLTKUIPlugin.log((Throwable)x);
            }
        }
        return types;
    }

    protected TemplateCompletionProcessor createTemplateProposalComputer(ScriptContentAssistInvocationContext context) {
        return new TclTemplateCompletionProcessor(context);
    }

    protected ScriptCompletionProposalCollector createCollector(ScriptContentAssistInvocationContext context) {
        TclCompletionProposalCollector collector = new TclCompletionProposalCollector(context.getSourceModule());
        collector.setIgnored(11, true);
        collector.setIgnored(1, true);
        collector.setIgnored(2, true);
        collector.setIgnored(3, true);
        collector.setIgnored(4, true);
        collector.setIgnored(6, true);
        collector.setIgnored(10, true);
        collector.setIgnored(5, true);
        collector.setIgnored(9, true);
        collector.setIgnored(8, true);
        collector.setIgnored(7, false);
        return collector;
    }
}

