/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.commands.IDbgpContextCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.DbgpRequest;
import org.eclipse.dltk.dbgp.internal.commands.DbgpBaseCommands;
import org.eclipse.dltk.dbgp.internal.commands.IDbgpCommunicator;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlEntityParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DbgpContextCommands
extends DbgpBaseCommands
implements IDbgpContextCommands {
    private static final String CONTEXT_NAMES_COMMAND = "context_names";
    private static final String CONTEXT_GET = "context_get";
    private static final String TAG_CONTEXT = "context";
    private static final String TAG_PROPERTY = "property";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ID = "id";

    public DbgpContextCommands(IDbgpCommunicator communicator) {
        super(communicator);
    }

    protected Map parseContextNamesResponse(Element response) throws DbgpException {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        NodeList contexts = response.getElementsByTagName(TAG_CONTEXT);
        int i = 0;
        while (i < contexts.getLength()) {
            Element context = (Element)contexts.item(i);
            String name = context.getAttribute(ATTR_NAME);
            Integer id = new Integer(context.getAttribute(ATTR_ID));
            map.put(id, name);
            ++i;
        }
        return map;
    }

    protected IDbgpProperty[] parseContextPropertiesResponse(Element response) throws DbgpException {
        NodeList properties = response.getChildNodes();
        ArrayList<IDbgpProperty> list = new ArrayList<IDbgpProperty>();
        int i = 0;
        while (i < properties.getLength()) {
            Node item = properties.item(i);
            if (item instanceof Element && item.getNodeName().equals(TAG_PROPERTY)) {
                list.add(DbgpXmlEntityParser.parseProperty((Element)item));
            }
            ++i;
        }
        return list.toArray(new IDbgpProperty[list.size()]);
    }

    public Map getContextNames(int stackDepth) throws DbgpException {
        DbgpRequest request = this.createRequest(CONTEXT_NAMES_COMMAND);
        request.addOption("-d", stackDepth);
        return this.parseContextNamesResponse(this.communicate(request));
    }

    public IDbgpProperty[] getContextProperties(int stackDepth) throws DbgpException {
        DbgpRequest request = this.createRequest(CONTEXT_GET);
        request.addOption("-d", stackDepth);
        return this.parseContextPropertiesResponse(this.communicate(request));
    }

    public IDbgpProperty[] getContextProperties(int stackDepth, int contextId) throws DbgpException {
        DbgpRequest request = this.createRequest(CONTEXT_GET);
        request.addOption("-d", stackDepth);
        request.addOption("-c", contextId);
        return this.parseContextPropertiesResponse(this.communicate(request));
    }
}

