/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntry;
import org.eclipse.dltk.launching.IRuntimeBuildpathProvider;
import org.eclipse.dltk.launching.ScriptRuntime;

public class StandardBuildpathProvider
implements IRuntimeBuildpathProvider {
    public IRuntimeBuildpathEntry[] computeUnresolvedBuildpath(ILaunchConfiguration configuration) throws CoreException {
        boolean useDefault = configuration.getAttribute("defaultBuildpath", true);
        if (useDefault) {
            IScriptProject proj = ScriptRuntime.getScriptProject(configuration);
            IRuntimeBuildpathEntry InterpreterEnvironmentEntry = ScriptRuntime.computeInterpreterEntry(configuration);
            if (proj == null) {
                if (InterpreterEnvironmentEntry == null) {
                    return new IRuntimeBuildpathEntry[0];
                }
                return new IRuntimeBuildpathEntry[]{InterpreterEnvironmentEntry};
            }
            IRuntimeBuildpathEntry[] entries = ScriptRuntime.computeUnresolvedRuntimeBuildpath(proj);
            IRuntimeBuildpathEntry projEntry = ScriptRuntime.computeInterpreterEntry(proj);
            if (InterpreterEnvironmentEntry != null && projEntry != null && !InterpreterEnvironmentEntry.equals(projEntry)) {
                int i = 0;
                while (i < entries.length) {
                    IRuntimeBuildpathEntry entry = entries[i];
                    if (entry.equals(projEntry)) {
                        entries[i] = InterpreterEnvironmentEntry;
                        return entries;
                    }
                    ++i;
                }
            }
            return entries;
        }
        return this.recoverRuntimePath(configuration, "buildpath");
    }

    public IRuntimeBuildpathEntry[] resolveBuildpath(IRuntimeBuildpathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        ArrayList<IRuntimeBuildpathEntry> all = new ArrayList<IRuntimeBuildpathEntry>(entries.length);
        int i = 0;
        while (i < entries.length) {
            IRuntimeBuildpathEntry[] resolved = ScriptRuntime.resolveRuntimeBuildpathEntry(entries[i], configuration);
            int j = 0;
            while (j < resolved.length) {
                all.add(resolved[j]);
                ++j;
            }
            ++i;
        }
        return all.toArray(new IRuntimeBuildpathEntry[all.size()]);
    }

    protected IRuntimeBuildpathEntry[] recoverRuntimePath(ILaunchConfiguration configuration, String attribute) throws CoreException {
        List entries = configuration.getAttribute(attribute, Collections.EMPTY_LIST);
        IRuntimeBuildpathEntry[] rtes = new IRuntimeBuildpathEntry[entries.size()];
        Iterator iter = entries.iterator();
        int i = 0;
        while (iter.hasNext()) {
            rtes[i] = ScriptRuntime.newRuntimeBuildpathEntry((String)iter.next());
            ++i;
        }
        return rtes;
    }
}

