/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifierOperation;
import org.eclipse.dltk.internal.corext.buildpath.IBuildpathInformationProvider;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;

public class RemoveFromBuildpathOperation
extends BuildpathModifierOperation {
    public RemoveFromBuildpathOperation(BuildpathModifier.IBuildpathModifierListener listener, IBuildpathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_tooltip, 1);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        List result = null;
        this.fException = null;
        try {
            result = this.removeFromBuildpath(this.fInformationProvider.getRemoveLinkedFolderQuery(), this.getSelectedElements(), this.fInformationProvider.getScriptProject(), monitor);
        }
        catch (CoreException e) {
            this.fException = e;
            result = null;
        }
        super.handleResult(result, monitor);
    }

    public boolean isValid(List elements, int[] types) throws ModelException {
        if (elements.size() == 0) {
            return false;
        }
        IScriptProject project = this.fInformationProvider.getScriptProject();
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            IBuildpathEntry entry;
            Object element = iterator.next();
            if (!(element instanceof IProjectFragment || element instanceof IScriptProject || element instanceof BuildPathContainer)) {
                return false;
            }
            if (!(element instanceof IScriptProject ? !RemoveFromBuildpathOperation.isSourceFolder(project) : element instanceof IProjectFragment && (entry = ((IProjectFragment)element).getRawBuildpathEntry()) != null && entry.getEntryKind() == 5)) continue;
            return false;
        }
        return true;
    }

    public String getDescription(int type) {
        IModelElement elem = (IModelElement)this.getSelectedElements().get(0);
        String name = RemoveFromBuildpathOperation.escapeSpecialChars(elem.getElementName());
        if (type == 1) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ProjectFromBuildpath, name);
        }
        if (type == 2 || type == 14) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_fromBuildpath, name);
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_FromBuildpath;
    }
}

