/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.util.ArrayList;
import org.eclipse.dltk.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.dltk.ui.preferences.FormatterMessages;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class EditorConfigurationBlock
extends AbstractConfigurationBlock {
    private boolean smartDisabled = false;
    boolean tabAlwaysIndent = false;

    public EditorConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store) {
        super(store, mainPreferencePage);
        this.getPreferenceStore().addKeys(this.createOverlayStoreKeys());
    }

    public EditorConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store, boolean disableSmart) {
        super(store, mainPreferencePage);
        this.getPreferenceStore().addKeys(this.createOverlayStoreKeys());
        this.smartDisabled = disableSmart;
    }

    public EditorConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store, boolean disableSmart, boolean tabAlwaysIndent) {
        super(store, mainPreferencePage);
        this.getPreferenceStore().addKeys(this.createOverlayStoreKeys());
        this.smartDisabled = disableSmart;
        this.tabAlwaysIndent = tabAlwaysIndent;
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Navigation.SmartHomeEnd"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "subWordNavigation"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editorSmartIndent"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "formatter.tabulation.char"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "formatter.tabulation.size"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "formatter.indentation.size"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "tab_always_indent"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public Control createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        if (!this.smartDisabled) {
            Composite composite = this.createSubsection(control, null, PreferencesMessages.EditorPreferencePage_title0);
            this.createSettingsGroup(composite);
        }
        this.createTabsGroup(control);
        return control;
    }

    private void createTabsGroup(Composite composite) {
        Composite generalGroup = this.createSubsection(composite, null, FormatterMessages.IndentationTabPage_preview_header);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        generalGroup.setLayout((Layout)layout);
        String[] tabPolicyValues = new String[]{"space", "tab", "mixed"};
        String[] tabPolicyLabels = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_MIXED};
        this.addComboBox(generalGroup, FormatterMessages.IndentationTabPage_general_group_option_tab_policy, "formatter.tabulation.char", tabPolicyLabels, tabPolicyValues);
        this.addLabelledTextField(generalGroup, FormatterMessages.IndentationTabPage_general_group_option_indent_size, "formatter.indentation.size", 2, 1, true);
        this.addLabelledTextField(generalGroup, FormatterMessages.IndentationTabPage_general_group_option_tab_size, "formatter.tabulation.size", 2, 1, true);
        if (this.tabAlwaysIndent) {
            this.addCheckBox(generalGroup, PreferencesMessages.EditorPreferencePage_tabAlwaysIndent, "tab_always_indent", 2);
        }
    }

    private Control createSettingsGroup(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        String label = PreferencesMessages.EditorPreferencePage_smartHomeEnd;
        this.addCheckBox(composite, label, "AbstractTextEditor.Navigation.SmartHomeEnd", 0);
        label = PreferencesMessages.EditorPreferencePage_subWordNavigation;
        this.addCheckBox(composite, label, "subWordNavigation", 0);
        label = PreferencesMessages.EditorPreferencePage_smartIndent;
        this.addCheckBox(composite, label, "editorSmartIndent", 0);
        return composite;
    }

    public void initialize() {
        super.initialize();
    }

    public void performDefaults() {
        super.performDefaults();
    }
}

