/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationEngine;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationListener;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationResult;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.internal.debug.core.model.ScriptWatchExpressionResult;

public class ScriptWatchExpressionDelegate
implements IWatchExpressionDelegate {
    protected static IScriptThread getScriptThread(Object context) {
        if (context instanceof IScriptThread) {
            return (IScriptThread)context;
        }
        if (context instanceof IScriptStackFrame) {
            return (IScriptThread)((IScriptStackFrame)context).getThread();
        }
        return null;
    }

    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        IScriptEvaluationEngine engine;
        IScriptThread thread = ScriptWatchExpressionDelegate.getScriptThread(context);
        if (thread != null && (engine = thread.getEvaluationEngine()) != null) {
            engine.asyncEvaluate(expression, null, new ListenerAdpater(listener));
        }
    }

    protected String prepareExpression(String expression) {
        return expression;
    }

    private static class ListenerAdpater
    implements IScriptEvaluationListener {
        private final IWatchExpressionListener listener;

        public ListenerAdpater(IWatchExpressionListener listener) {
            this.listener = listener;
        }

        public void evaluationComplete(IScriptEvaluationResult result) {
            this.listener.watchEvaluationFinished((IWatchExpressionResult)new ScriptWatchExpressionResult(result));
        }
    }
}

