/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.interpreters;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.interpreters.AddScriptInterpreterDialog;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.internal.debug.ui.interpreters.LibraryContentProvider;
import org.eclipse.dltk.internal.debug.ui.interpreters.LibraryStandin;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractInterpreterLibraryBlock
implements SelectionListener,
ISelectionChangedListener {
    protected static final String LAST_PATH_SETTING = "LAST_PATH_SETTING";
    protected static final String DIALOG_SETTINGS_PREFIX = "AbstractInterpreterLibraryBlock";
    protected boolean fInCallback = false;
    protected IInterpreterInstall fInterpreterInstall;
    protected IInterpreterInstallType fInterpreterInstallType;
    protected File fHome;
    protected LibraryContentProvider fLibraryContentProvider;
    protected TreeViewer fLibraryViewer;
    private Button fUpButton;
    private Button fDownButton;
    private Button fRemoveButton;
    private Button fAddButton;
    protected Button fDefaultButton;
    protected AddScriptInterpreterDialog fDialog;

    protected AbstractInterpreterLibraryBlock(AddScriptInterpreterDialog dialog) {
        this.fDialog = dialog;
    }

    public Control createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.fLibraryViewer = new TreeViewer(comp);
        gd = new GridData(1808);
        gd.heightHint = 6;
        this.fLibraryViewer.getControl().setLayoutData((Object)gd);
        this.fLibraryContentProvider = new LibraryContentProvider();
        this.fLibraryViewer.setContentProvider((IContentProvider)this.fLibraryContentProvider);
        this.fLibraryViewer.setLabelProvider(this.getLabelProvider());
        this.fLibraryViewer.setInput((Object)this);
        this.fLibraryViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.fAddButton = this.createPushButton(pathButtonComp, InterpretersMessages.InterpreterLibraryBlock_7);
        this.fAddButton.addSelectionListener((SelectionListener)this);
        this.fRemoveButton = this.createPushButton(pathButtonComp, InterpretersMessages.InterpreterLibraryBlock_6);
        this.fRemoveButton.addSelectionListener((SelectionListener)this);
        this.fUpButton = this.createPushButton(pathButtonComp, InterpretersMessages.InterpreterLibraryBlock_4);
        this.fUpButton.addSelectionListener((SelectionListener)this);
        this.fDownButton = this.createPushButton(pathButtonComp, InterpretersMessages.InterpreterLibraryBlock_5);
        this.fDownButton.addSelectionListener((SelectionListener)this);
        this.fDefaultButton = this.createPushButton(pathButtonComp, InterpretersMessages.InterpreterLibraryBlock_9);
        this.fDefaultButton.addSelectionListener((SelectionListener)this);
        return comp;
    }

    public void restoreDefaultLibraries() {
        final LibraryLocation[][] libs = new LibraryLocation[1][];
        final File installLocation = this.getHomeDirectory();
        if (installLocation == null) {
            libs[0] = new LibraryLocation[0];
        } else {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(null);
            try {
                dialog.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        libs[0] = AbstractInterpreterLibraryBlock.this.getInterpreterInstallType().getDefaultLibraryLocations(installLocation);
                    }
                });
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (libs != null) {
            this.fLibraryContentProvider.setLibraries(libs[0]);
        }
        this.update();
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        this.setButtonLayoutData(button);
        return button;
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    public void setHomeDirectory(File file) {
        this.fHome = file;
    }

    protected File getHomeDirectory() {
        return this.fHome;
    }

    public void update() {
        this.updateButtons();
        IStatus status = Status.OK_STATUS;
        if (this.fLibraryContentProvider.getLibraries().length == 0) {
            status = new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, InterpretersMessages.InterpreterLibraryBlock_Libraries_cannot_be_empty__1, null);
        }
        LibraryStandin[] standins = this.fLibraryContentProvider.getStandins();
        int i = 0;
        while (i < standins.length) {
            IStatus st = standins[i].validate();
            if (!st.isOK()) {
                status = st;
                break;
            }
            ++i;
        }
        this.updateDialogStatus(status);
    }

    public void performApply(IInterpreterInstall install) {
        if (this.isDefaultLocations()) {
            install.setLibraryLocations(null);
        } else {
            LibraryLocation[] libs = this.fLibraryContentProvider.getLibraries();
            install.setLibraryLocations(libs);
        }
    }

    protected boolean isDefaultLocations() {
        LibraryLocation[] def;
        LibraryLocation[] libraryLocations = this.fLibraryContentProvider.getLibraries();
        IInterpreterInstall install = this.getInterpreterInstall();
        if (install == null || libraryLocations == null) {
            return true;
        }
        File installLocation = install.getInstallLocation();
        if (installLocation != null && (def = this.getInterpreterInstallType().getDefaultLibraryLocations(installLocation)).length == libraryLocations.length) {
            int i = 0;
            while (i < def.length) {
                if (!def[i].equals((Object)libraryLocations[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected IInterpreterInstall getInterpreterInstall() {
        return this.fInterpreterInstall;
    }

    protected IInterpreterInstallType getInterpreterInstallType() {
        return this.fInterpreterInstallType;
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.fUpButton) {
            this.fLibraryContentProvider.up((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fDownButton) {
            this.fLibraryContentProvider.down((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fRemoveButton) {
            this.fLibraryContentProvider.remove((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fAddButton) {
            this.add((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fDefaultButton) {
            this.restoreDefaultLibraries();
        }
        this.update();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void add(IStructuredSelection selection) {
        LibraryLocation libs = this.add();
        if (libs == null) {
            return;
        }
        this.fLibraryContentProvider.add(new LibraryLocation[]{libs}, selection);
        this.update();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fLibraryViewer.getSelection();
        this.fRemoveButton.setEnabled(!selection.isEmpty());
        boolean enableUp = true;
        boolean enableDown = true;
        Object[] libraries = this.fLibraryContentProvider.getElements(null);
        if (selection.isEmpty() || libraries.length == 0) {
            enableUp = false;
            enableDown = false;
        } else {
            Object first = libraries[0];
            Object last = libraries[libraries.length - 1];
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Object lib = element;
                if (lib == first) {
                    enableUp = false;
                }
                if (lib != last) continue;
                enableDown = false;
            }
        }
        this.fUpButton.setEnabled(enableUp);
        this.fDownButton.setEnabled(enableDown);
    }

    public void initializeFrom(IInterpreterInstall Interpreter, IInterpreterInstallType type) {
        this.fInterpreterInstall = Interpreter;
        this.fInterpreterInstallType = type;
        if (Interpreter != null) {
            this.setHomeDirectory(Interpreter.getInstallLocation());
            this.fLibraryContentProvider.setLibraries(ScriptRuntime.getLibraryLocations((IInterpreterInstall)this.getInterpreterInstall()));
        }
        this.update();
    }

    protected abstract IBaseLabelProvider getLabelProvider();

    protected void updateDialogStatus(IStatus status) {
        this.fDialog.setSystemLibraryStatus(status);
        this.fDialog.updateStatusLine();
    }

    protected void setButtonLayoutData(Button button) {
        this.fDialog.setButtonLayoutData(button);
    }

    protected abstract IDialogSettings getDialogSettions();

    protected LibraryLocation add() {
        IDialogSettings dialogSettings = this.getDialogSettions();
        String lastUsedPath = dialogSettings.get(LAST_PATH_SETTING);
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        DirectoryDialog dialog = new DirectoryDialog(this.fLibraryViewer.getControl().getShell(), 2);
        dialog.setMessage(InterpretersMessages.InterpreterLibraryBlock_10);
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        Path path = new Path(res);
        LibraryLocation lib = new LibraryLocation(path.makeAbsolute());
        dialogSettings.put(LAST_PATH_SETTING, path.toOSString());
        return lib;
    }
}

