/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.documentation;

import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.corext.documentation.SingleCharReader;

public class TclCommentReader
extends SingleCharReader {
    private IBuffer fBuffer;
    private int fCurrPos;
    private int fStartPos;
    private int fEndPos;
    private boolean fWasNewLine;

    public TclCommentReader(IBuffer buf, int start, int end) {
        this.fBuffer = buf;
        this.fStartPos = start;
        this.fEndPos = end;
        this.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() {
        char ch;
        if (this.fCurrPos >= this.fEndPos) return -1;
        if (this.fWasNewLine) {
            do {
                ch = this.fBuffer.getChar(this.fCurrPos++);
            } while (this.fCurrPos < this.fEndPos && Character.isWhitespace(ch));
            if (ch == '#') {
                if (this.fCurrPos >= this.fEndPos) return -1;
                while ((ch = this.fBuffer.getChar(this.fCurrPos++)) == '#') {
                }
            }
        } else {
            ch = this.fBuffer.getChar(this.fCurrPos++);
        }
        this.fWasNewLine = ch == '\n' || ch == '\r';
        return ch;
    }

    public void close() {
        this.fBuffer = null;
    }

    public void reset() {
        this.fCurrPos = this.fStartPos;
        this.fWasNewLine = true;
    }

    public int getOffset() {
        return this.fCurrPos;
    }
}

