/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.launching;

import java.util.HashMap;
import junit.framework.Test;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.internal.launching.EnvironmentResolver;
import org.eclipse.dltk.launching.EnvironmentVariable;

public class EnvironmentResolverTests
extends SuiteOfTestCases {
    static /* synthetic */ Class class$0;

    public EnvironmentResolverTests(String name) {
        super(name);
    }

    public void testEnvironmentResolve001() {
        HashMap env = new HashMap();
        EnvironmentVariable[] vars = new EnvironmentVariable[]{this.mk("A", "a")};
        EnvironmentVariable[] resolve = EnvironmentResolver.resolve(env, (EnvironmentVariable[])vars);
        EnvironmentResolverTests.assertNotNull((Object)resolve);
        this.test(resolve, "A", "a");
    }

    public void testEnvironmentResolve002() {
        HashMap env = new HashMap();
        EnvironmentVariable[] vars = new EnvironmentVariable[]{this.mk("A", "a"), this.mk("B", "a$Ac")};
        EnvironmentVariable[] resolve = EnvironmentResolver.resolve(env, (EnvironmentVariable[])vars);
        EnvironmentResolverTests.assertNotNull((Object)resolve);
        this.test(resolve, "A", "a");
        this.test(resolve, "B", "aac");
    }

    public void testEnvironmentResolve003() {
        HashMap env = new HashMap();
        EnvironmentVariable[] vars = new EnvironmentVariable[]{this.mk("AUTOTEST", "/Develop/cisco/ats5.0.0"), this.mk("ATS_EASY", "$AUTOTEST/ats_easy")};
        EnvironmentVariable[] resolve = EnvironmentResolver.resolve(env, (EnvironmentVariable[])vars);
        EnvironmentResolverTests.assertNotNull((Object)resolve);
        this.test(resolve, "AUTOTEST", "/Develop/cisco/ats5.0.0");
        this.test(resolve, "ATS_EASY", "/Develop/cisco/ats5.0.0/ats_easy");
    }

    public void testEnvironmentResolve004() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("PATH", "/bin:/usr/bin");
        EnvironmentVariable[] vars = new EnvironmentVariable[]{this.mk("PATH", "/sbin:$PATH")};
        EnvironmentVariable[] resolve = EnvironmentResolver.resolve(env, (EnvironmentVariable[])vars);
        EnvironmentResolverTests.assertNotNull((Object)resolve);
        this.test(resolve, "PATH", "/sbin:/bin:/usr/bin");
    }

    public void testEnvironmentResolve005() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("PATH", "/bin:/usr/bin");
        EnvironmentVariable[] vars = new EnvironmentVariable[]{new EnvironmentVariable("a1", "A1"), new EnvironmentVariable("a2", "A2$a1"), new EnvironmentVariable("a3", "A3$a2"), new EnvironmentVariable("a4", "A4$a3")};
        EnvironmentVariable[] resolve = EnvironmentResolver.resolve(env, (EnvironmentVariable[])vars);
        EnvironmentResolverTests.assertNotNull((Object)resolve);
        this.test(resolve, "a1", "A1");
        this.test(resolve, "a2", "A2A1");
        this.test(resolve, "a3", "A3A2A1");
        this.test(resolve, "a4", "A4A3A2A1");
    }

    public void testEnvironmentResolve006() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("PATH", "/bin:/usr/bin");
        EnvironmentVariable[] vars = new EnvironmentVariable[]{new EnvironmentVariable("a1", "A1$a4"), new EnvironmentVariable("a2", "A2$a1"), new EnvironmentVariable("a3", "A3$a2"), new EnvironmentVariable("a4", "A4$a3")};
        EnvironmentVariable[] resolve = EnvironmentResolver.resolve(env, (EnvironmentVariable[])vars);
        EnvironmentResolverTests.assertEquals((int)resolve.length, (int)0);
    }

    public void testEnvironmentResolve007() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("PATH", "/bin:/usr/bin");
        EnvironmentVariable[] vars = new EnvironmentVariable[]{new EnvironmentVariable("a1", "$a2"), new EnvironmentVariable("a2", "a2")};
        EnvironmentVariable[] resolve = EnvironmentResolver.resolve(env, (EnvironmentVariable[])vars);
        EnvironmentResolverTests.assertEquals((int)resolve.length, (int)2);
        this.test(resolve, "a1", "a2");
        this.test(resolve, "a2", "a2");
    }

    public void testEnvironmentResolve008() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("PATH", "/bin:/usr/bin");
        EnvironmentVariable[] vars = new EnvironmentVariable[]{new EnvironmentVariable("PATH", "/sbii/bin/:$PATH"), new EnvironmentVariable("a2", "alla{$PATH}")};
        EnvironmentVariable[] resolve = EnvironmentResolver.resolve(env, (EnvironmentVariable[])vars);
        EnvironmentResolverTests.assertEquals((int)resolve.length, (int)2);
        this.test(resolve, "PATH", "/sbii/bin/:/bin:/usr/bin");
        this.test(resolve, "a2", "alla{/sbii/bin/:/bin:/usr/bin}");
    }

    private void test(EnvironmentVariable[] resolve, String b, String v) {
        this.assertContains(resolve, this.mk(b, v));
    }

    private EnvironmentVariable mk(String name, String value) {
        return new EnvironmentVariable(name, value);
    }

    private void assertContains(EnvironmentVariable[] resolve, EnvironmentVariable environmentVariable) {
        String name = environmentVariable.getName();
        int i = 0;
        while (i < resolve.length) {
            if (resolve[i].equals((Object)environmentVariable)) {
                return;
            }
            if (resolve[i].getName().equals(name)) {
                EnvironmentResolverTests.assertTrue((String)("Variable:" + name + "=>" + resolve[i].getValue() + "!=" + environmentVariable.getValue()), (boolean)false);
            }
            ++i;
        }
        EnvironmentResolverTests.assertTrue((boolean)false);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.core.tests.launching.EnvironmentResolverTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite(clazz);
    }
}

