/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.tests.launching.IFileVisitor;
import org.eclipse.dltk.core.tests.launching.PathFilesContainer;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.ScriptRuntime;

public class InterpreterSearcher {
    private List types = new ArrayList();
    private ArrayList found = new ArrayList();
    private String natureId;
    private Set ignore;

    public void search(IEnvironment environment, String natureId, Set ignore, int deep, IProgressMonitor monsitor) {
        if (natureId == null) {
            throw new IllegalArgumentException();
        }
        this.found.clear();
        this.types.clear();
        this.natureId = natureId;
        this.ignore = ignore == null ? Collections.EMPTY_SET : ignore;
        Searcher searcher = new Searcher();
        PathFilesContainer path = new PathFilesContainer(environment);
        path.accept(searcher);
    }

    public boolean hasResults() {
        return !this.found.isEmpty();
    }

    public IFileHandle[] getFoundFiles() {
        return this.found.toArray(new IFileHandle[this.found.size()]);
    }

    public IInterpreterInstallType[] getFoundInstallTypes() {
        return this.types.toArray(new IInterpreterInstallType[this.types.size()]);
    }

    class Searcher
    implements IFileVisitor {
        Searcher() {
        }

        public boolean visit(IFileHandle file) {
            IInterpreterInstallType[] installTypes = ScriptRuntime.getInterpreterInstallTypes((String)InterpreterSearcher.this.natureId);
            boolean interpreterFound = false;
            if (!InterpreterSearcher.this.ignore.contains(file)) {
                int j = 0;
                while (j < installTypes.length) {
                    IInterpreterInstallType installType = installTypes[j];
                    IStatus status = installType.validateInstallLocation(file);
                    if (status.isOK()) {
                        InterpreterSearcher.this.found.add(file);
                        InterpreterSearcher.this.types.add(installType);
                        interpreterFound = true;
                        break;
                    }
                    ++j;
                }
            }
            return !interpreterFound;
        }
    }
}

