/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.CopyProjectFragmentOperation;
import org.eclipse.dltk.internal.core.CreateScriptFolderOperation;
import org.eclipse.dltk.internal.core.DeleteProjectFragmentOperation;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.MoveProjectFragmentOperation;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ProjectFragmentInfo;
import org.eclipse.dltk.internal.core.ScriptFolder;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.dltk.utils.CorePrinter;

public class ProjectFragment
extends Openable
implements IProjectFragment {
    protected Object resource;

    protected ProjectFragment(IResource resource, ScriptProject project) {
        super(project);
        this.resource = resource;
    }

    public boolean isArchive() {
        return false;
    }

    protected Object createElementInfo() {
        return new ProjectFragmentInfo();
    }

    public int getElementType() {
        return 3;
    }

    public IResource getResource() {
        return (IResource)this.resource;
    }

    public IPath getPath() {
        return this.getResource().getFullPath();
    }

    public int getKind() throws ModelException {
        Object elementInfo = this.getElementInfo();
        return ((ProjectFragmentInfo)elementInfo).getRootKind();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectFragment)) {
            return false;
        }
        ProjectFragment other = (ProjectFragment)o;
        if (this.resource == null && other.resource != null) {
            return false;
        }
        if (this.resource != null && other.resource == null) {
            return false;
        }
        if (this.resource != null && other.resource != null && !this.resource.equals(other.resource)) {
            return false;
        }
        return this.parent.equals(other.parent);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelException {
        IStatus status = this.validateOnBuildpath();
        if (!status.isOK()) {
            throw this.newModelException(status);
        }
        if (!this.resourceExists()) {
            throw this.newNotPresentException();
        }
        return this.computeChildren(info, newElements);
    }

    protected IStatus validateOnBuildpath() {
        IPath path = this.getPath();
        try {
            ScriptProject project = (ScriptProject)this.getScriptProject();
            IBuildpathEntry[] buildpath = project.getResolvedBuildpath();
            int i = 0;
            int length = buildpath.length;
            while (i < length) {
                IBuildpathEntry entry = buildpath[i];
                if (entry.getPath().equals((Object)path)) {
                    return Status.OK_STATUS;
                }
                ++i;
            }
        }
        catch (ModelException e) {
            return e.getModelStatus();
        }
        return new ModelStatus(1006, this);
    }

    protected boolean computeChildren(OpenableElementInfo info, Map newElements) throws ModelException {
        try {
            IResource underlyingResource = this.getResource();
            if (underlyingResource.getType() == 2 || underlyingResource.getType() == 4) {
                char[][] exclusionPatterns;
                IContainer rootFolder;
                ArrayList vChildren = new ArrayList(5);
                char[][] inclusionPatterns = this.fullInclusionPatternChars();
                this.computeFolderChildren(rootFolder, !Util.isExcluded((IResource)(rootFolder = (IContainer)underlyingResource), inclusionPatterns, exclusionPatterns = this.fullExclusionPatternChars()), (IPath)Path.EMPTY, vChildren, inclusionPatterns, exclusionPatterns);
                IModelElement[] children = new IModelElement[vChildren.size()];
                vChildren.toArray(children);
                info.setChildren(children);
            }
        }
        catch (ModelException e) {
            info.setChildren(new IModelElement[0]);
            throw e;
        }
        return true;
    }

    protected void computeFolderChildren(IContainer folder, boolean isIncluded, IPath path, ArrayList vChildren, char[][] inclusionPatterns, char[][] exclusionPatterns) throws ModelException {
        if (isIncluded) {
            IScriptFolder pkg = this.getScriptFolder(path);
            vChildren.add(pkg);
        }
        try {
            ScriptProject scriptProject = (ScriptProject)this.getScriptProject();
            ModelManager manager = ModelManager.getModelManager();
            IResource[] members = folder.members();
            boolean hasIncluded = isIncluded;
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource member = members[i];
                String memberName = member.getName();
                switch (member.getType()) {
                    case 2: {
                        if (!Util.isValidFolderNameForPackage(memberName) || !scriptProject.contains(member)) break;
                        IPath newPath = path.append(manager.intern(memberName));
                        boolean isMemberIncluded = !Util.isExcluded(member, inclusionPatterns, exclusionPatterns);
                        this.computeFolderChildren((IContainer)((IFolder)member), isMemberIncluded, newPath, vChildren, inclusionPatterns, exclusionPatterns);
                        break;
                    }
                    case 1: {
                        if (hasIncluded || !Util.isValidSourceModule((IModelElement)this, member) || Util.isExcluded(member, inclusionPatterns, exclusionPatterns)) break;
                        hasIncluded = true;
                        IScriptFolder pkg = this.getScriptFolder(path);
                        vChildren.add(pkg);
                    }
                }
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            throw new ModelException(e, 969);
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    public IScriptFolder getScriptFolder(IPath path) {
        return new ScriptFolder(this, path);
    }

    public String getElementName() {
        if (this.resource instanceof IFolder) {
            return ((IFolder)this.resource).getName();
        }
        return super.getElementName();
    }

    public boolean exists() {
        return super.exists() && this.validateOnBuildpath().isOK();
    }

    public boolean isExternal() {
        return false;
    }

    public IResource getUnderlyingResource() throws ModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.getResource();
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        IPath path = this.getPath();
        if (this.getScriptProject().getElementName().equals(path.segment(0))) {
            if (path.segmentCount() == 1) {
                buffer.append("<project root>");
            } else {
                buffer.append(path.removeFirstSegments(1).makeRelative());
            }
        } else if (this.isExternal()) {
            buffer.append(path.toOSString());
        } else {
            buffer.append(path);
        }
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    public void printNode(CorePrinter output) {
        output.formatPrint("ScriptProject fragment:" + this.getPath().toOSString());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + element);
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }

    public IScriptFolder getScriptFolder(String path) {
        return this.getScriptFolder((IPath)new Path(path));
    }

    public Object[] getForeignResources() throws ModelException {
        return ((ProjectFragmentInfo)this.getElementInfo()).getForeignResources(this.getScriptProject(), this.getResource(), this);
    }

    public char[][] fullExclusionPatternChars() {
        BuildpathEntry entry;
        block5: {
            block4: {
                try {
                    if (!this.isOpen() || this.getKind() == 1) break block4;
                    return null;
                }
                catch (ModelException modelException) {
                    return null;
                }
            }
            entry = (BuildpathEntry)this.getBuildpathEntry();
            if (entry != null) break block5;
            return null;
        }
        return entry.fullExclusionPatternChars();
    }

    public char[][] fullInclusionPatternChars() {
        BuildpathEntry entry;
        block5: {
            block4: {
                try {
                    if (!this.isOpen() || this.getKind() == 1) break block4;
                    return null;
                }
                catch (ModelException modelException) {
                    return null;
                }
            }
            entry = (BuildpathEntry)this.getBuildpathEntry();
            if (entry != null) break block5;
            return null;
        }
        return entry.fullInclusionPatternChars();
    }

    public IBuildpathEntry getRawBuildpathEntry() throws ModelException {
        IBuildpathEntry rawEntry = null;
        ScriptProject project = (ScriptProject)this.getScriptProject();
        project.getResolvedBuildpath();
        Map rootPathToRawEntries = project.getPerProjectInfo().resolvedPathToRawEntries;
        if (rootPathToRawEntries != null) {
            rawEntry = (IBuildpathEntry)rootPathToRawEntries.get(this.getPath());
        }
        if (rawEntry == null) {
            throw new ModelException(new ModelStatus(1006, this));
        }
        return rawEntry;
    }

    public IBuildpathEntry getBuildpathEntry() throws ModelException {
        return this.getRawBuildpathEntry();
    }

    protected void getHandleMemento(StringBuffer buff) {
        ((ModelElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        IPath path = ((IResource)this.resource).getProjectRelativePath();
        this.escapeMementoName(buff, path.toString());
    }

    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '<': {
                String pkgName;
                if (memento.hasMoreTokens()) {
                    pkgName = memento.nextToken();
                    char firstChar = pkgName.charAt(0);
                    if (firstChar == '{' || firstChar == '!') {
                        token = pkgName;
                        pkgName = "";
                    } else {
                        token = null;
                    }
                } else {
                    pkgName = "";
                    token = null;
                }
                ModelElement pkg = (ModelElement)((Object)this.getScriptFolder(pkgName));
                if (token == null) {
                    return pkg.getHandleFromMemento(memento, owner);
                }
                return pkg.getHandleFromMemento(token, memento, owner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '/';
    }

    public IScriptFolder createScriptFolder(String pkgName, boolean force, IProgressMonitor monitor) throws ModelException {
        CreateScriptFolderOperation op = new CreateScriptFolderOperation(this, pkgName, force);
        op.runOperation(monitor);
        return this.getScriptFolder(op.pkgName);
    }

    public void delete(int updateResourceFlags, int updateModelFlags, IProgressMonitor monitor) throws ModelException {
        DeleteProjectFragmentOperation op = new DeleteProjectFragmentOperation(this, updateResourceFlags, updateModelFlags);
        op.runOperation(monitor);
    }

    public void copy(IPath destination, int updateResourceFlags, int updateModelFlags, IBuildpathEntry sibling, IProgressMonitor monitor) throws ModelException {
        CopyProjectFragmentOperation op = new CopyProjectFragmentOperation(this, destination, updateResourceFlags, updateModelFlags, sibling);
        op.runOperation(monitor);
    }

    public void move(IPath destination, int updateResourceFlags, int updateModelFlags, IBuildpathEntry sibling, IProgressMonitor monitor) throws ModelException {
        MoveProjectFragmentOperation op = new MoveProjectFragmentOperation(this, destination, updateResourceFlags, updateModelFlags, sibling);
        op.runOperation(monitor);
    }

    public IScriptFolder getScriptFolder(String[] pkgName) {
        if (pkgName.length == 0) {
            return this.getScriptFolder((IPath)Path.EMPTY);
        }
        Path path = new Path(pkgName[0]);
        int i = 1;
        while (i < pkgName.length) {
            path = path.append(pkgName[i]);
            ++i;
        }
        return this.getScriptFolder((IPath)path);
    }
}

