/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.validators.core.IValidator;
import org.eclipse.dltk.validators.core.IValidatorType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractValidator
implements IValidator {
    private String id;
    private String name;
    private IValidatorType type;
    private boolean active = true;

    protected AbstractValidator(String id, String name, IValidatorType type) {
        this.id = id;
        this.name = name;
        this.type = type;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    protected void loadFrom(Element element) {
        this.name = element.getAttribute("name");
        this.active = new Boolean(element.getAttribute("active"));
    }

    public void storeTo(Document doc, Element element) {
        element.setAttribute("name", this.getName());
        element.setAttribute("active", Boolean.toString(this.isActive()));
    }

    public void clean(IResource resource) {
    }

    public void clean(ISourceModule module) {
    }

    public boolean isValidatorValid() {
        return false;
    }

    public IValidatorType getValidatorType() {
        return this.type;
    }

    protected void setID(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

