/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.IDbgpStackLevel;
import org.eclipse.dltk.dbgp.commands.IDbgpContextCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpDebuggingEngineException;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.ScriptDebugManager;
import org.eclipse.dltk.debug.core.model.IScriptStack;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.internal.debug.core.model.Messages;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugElement;
import org.eclipse.dltk.internal.debug.core.model.ScriptVariable;
import org.eclipse.dltk.internal.debug.core.model.ScriptVariableWrapper;

public class ScriptStackFrame
extends ScriptDebugElement
implements IScriptStackFrame {
    private static final String STACK_FRAME_LABEL = Messages.ScriptStackFrame_stackFrame;
    private IScriptStack stack;
    private IScriptThread thread;
    private final IDbgpStackLevel level;
    private IScriptVariable[] variables;

    protected static IScriptVariable[] readVariables(ScriptStackFrame parentFrame, int contextId, IDbgpContextCommands commands) throws DbgpException {
        try {
            String name;
            IDbgpProperty property;
            IDbgpProperty[] properties = commands.getContextProperties(parentFrame.getLevel(), contextId);
            IScriptVariable[] variables = new IScriptVariable[properties.length];
            HashSet<String> useFullName = new HashSet<String>();
            HashSet<String> alreadyExsisting = new HashSet<String>();
            int i = 0;
            while (i < properties.length) {
                property = properties[i];
                name = property.getName();
                if (alreadyExsisting.contains(name)) {
                    useFullName.add(name);
                } else {
                    alreadyExsisting.add(name);
                }
                ++i;
            }
            i = 0;
            while (i < properties.length) {
                property = properties[i];
                name = property.getName();
                if (useFullName.contains(name)) {
                    name = property.getEvalName();
                }
                variables[i] = new ScriptVariable(parentFrame, property, name);
                ++i;
            }
            Arrays.sort(variables, ScriptDebugManager.getInstance().getVariableNameComparatorByDebugModel(parentFrame.getModelIdentifier()));
            return variables;
        }
        catch (DbgpDebuggingEngineException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return new IScriptVariable[0];
        }
    }

    protected IScriptVariable[] readAllVariables() throws DbgpException {
        IDbgpCoreCommands commands = this.thread.getDbgpSession().getCoreCommands();
        Map names = commands.getContextNames(this.getLevel());
        Integer localId = new Integer(0);
        Integer globalId = new Integer(1);
        Integer classId = new Integer(2);
        boolean showGlobal = this.thread.retrieveGlobalVariables();
        boolean showClass = this.thread.retrieveClassVariables();
        boolean showLocal = this.thread.retrieveLocalVariables();
        ScriptVariableContainer all = new ScriptVariableContainer();
        if (showLocal && names.containsKey(localId)) {
            all.add(ScriptStackFrame.readVariables(this, localId, commands));
        }
        if (showGlobal && names.containsKey(globalId)) {
            all.add(new ScriptVariableWrapper(this.getDebugTarget(), Messages.ScriptStackFrame_globalVariables, ScriptStackFrame.readVariables(this, globalId, commands)));
        }
        if (showClass && names.containsKey(classId)) {
            all.add(new ScriptVariableWrapper(this.getDebugTarget(), Messages.ScriptStackFrame_classVariables, ScriptStackFrame.readVariables(this, classId, commands)));
        }
        return all.get();
    }

    public ScriptStackFrame(IScriptStack stack, IDbgpStackLevel stackLevel) {
        this.stack = stack;
        this.thread = stack.getThread();
        this.level = stackLevel;
        this.updateVariables();
    }

    public void updateVariables() {
        this.variables = null;
    }

    public IScriptStack getStack() {
        return this.stack;
    }

    public URI getFileName() {
        return this.level.getFileURI();
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public int getLineNumber() throws DebugException {
        return this.level.getLineNumber();
    }

    public String getName() throws DebugException {
        String name = this.level.getWhere().trim();
        if (name == null || name.length() == 0) {
            name = this.toString();
        }
        name = String.valueOf(name) + " (" + this.level.getFileURI().getPath() + ")";
        return name;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public IThread getThread() {
        return this.thread;
    }

    public boolean hasVariables() throws DebugException {
        this.checkVariablesAvailable();
        return this.variables.length > 0;
    }

    private synchronized void checkVariablesAvailable() throws DebugException {
        if (this.variables == null) {
            try {
                this.variables = this.readAllVariables();
            }
            catch (DbgpException e) {
                this.variables = new IScriptVariable[0];
                Status status = new Status(4, "org.eclipse.dltk.debug", Messages.ScriptStackFrame_unableToLoadVariables, (Throwable)e);
                throw new DebugException((IStatus)status);
            }
        }
    }

    public IVariable[] getVariables() throws DebugException {
        this.checkVariablesAvailable();
        return (IVariable[])this.variables.clone();
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public IDebugTarget getDebugTarget() {
        return this.thread.getDebugTarget();
    }

    public IScriptVariable findVariable(String varName) throws DebugException {
        this.checkVariablesAvailable();
        int i = 0;
        while (i < this.variables.length) {
            if (this.variables[i].getName().equals(varName)) {
                return this.variables[i];
            }
            ++i;
        }
        return null;
    }

    public int getLevel() {
        return this.level.getLevel();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ScriptStackFrame) {
            return this.level.equals(((ScriptStackFrame)obj).level);
        }
        return false;
    }

    public int hashCode() {
        return this.level.hashCode();
    }

    public String toString() {
        return MessageFormat.format(STACK_FRAME_LABEL, new Integer(this.level.getLevel()));
    }

    public String getSourceLine() {
        return this.level.getWhere();
    }

    public URI getSourceURI() {
        return this.level.getFileURI();
    }

    public IScriptThread getScriptThread() {
        return (IScriptThread)this.getThread();
    }

    private static class ScriptVariableContainer {
        private final List list = new ArrayList();

        private ScriptVariableContainer() {
        }

        public void add(IScriptVariable variable) {
            this.list.add(variable);
        }

        public void add(IScriptVariable[] variables) {
            int i = 0;
            while (i < variables.length) {
                this.list.add(variables[i]);
                ++i;
            }
        }

        public IScriptVariable[] get() {
            return this.list.toArray(new IScriptVariable[this.list.size()]);
        }
    }
}

