/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.ui;

import org.eclipse.dltk.internal.testing.Messages;
import org.eclipse.dltk.internal.testing.model.TestCaseElement;
import org.eclipse.dltk.internal.testing.model.TestElement;
import org.eclipse.dltk.internal.testing.model.TestSuiteElement;
import org.eclipse.dltk.internal.testing.ui.DLTKTestingMessages;
import org.eclipse.dltk.internal.testing.ui.TestRunnerViewPart;
import org.eclipse.dltk.testing.model.ITestCaseElement;
import org.eclipse.dltk.testing.model.ITestElement;
import org.eclipse.dltk.testing.model.ITestRunSession;
import org.eclipse.dltk.testing.model.ITestSuiteElement;
import org.eclipse.dltk.ui.viewsupport.ColoredString;
import org.eclipse.dltk.ui.viewsupport.IRichLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TestSessionLabelProvider
extends LabelProvider
implements IRichLabelProvider {
    private final TestRunnerViewPart fTestRunnerPart;
    private final int fLayoutMode;

    public TestSessionLabelProvider(TestRunnerViewPart testRunnerPart, int layoutMode) {
        this.fTestRunnerPart = testRunnerPart;
        this.fLayoutMode = layoutMode;
    }

    public ColoredString getRichTextLabel(Object element) {
        String label = this.getSimpleLabel(element);
        if (label == null) {
            return new ColoredString(element.toString());
        }
        ColoredString text = new ColoredString(label);
        return text;
    }

    private String getSimpleLabel(Object element) {
        if (element instanceof ITestCaseElement) {
            return ((ITestCaseElement)element).getTestMethodName();
        }
        if (element instanceof ITestSuiteElement) {
            return ((ITestSuiteElement)element).getSuiteTypeName();
        }
        return null;
    }

    public String getText(Object element) {
        String label = this.getSimpleLabel(element);
        if (label == null) {
            return element.toString();
        }
        if (this.fLayoutMode == 1) {
            String testKindDisplayName;
            if (((ITestElement)element).getParentContainer() instanceof ITestRunSession && (testKindDisplayName = this.fTestRunnerPart.getTestKindDisplayName()) != null) {
                return Messages.format(DLTKTestingMessages.TestSessionLabelProvider_testName_JUnitVersion, new Object[]{label, testKindDisplayName});
            }
        } else if (element instanceof ITestCaseElement) {
            String className = ((ITestCaseElement)element).getTestClassName();
            return Messages.format(DLTKTestingMessages.TestSessionLabelProvider_testMethodName_className, new Object[]{label, className});
        }
        return label;
    }

    public Image getImage(Object element) {
        if (element instanceof TestCaseElement) {
            TestCaseElement testCaseElement = (TestCaseElement)element;
            if (testCaseElement.isIgnored()) {
                return this.fTestRunnerPart.fTestIgnoredIcon;
            }
            TestElement.Status status = testCaseElement.getStatus();
            if (status.isNotRun()) {
                return this.fTestRunnerPart.fTestIcon;
            }
            if (status.isRunning()) {
                return this.fTestRunnerPart.fTestRunningIcon;
            }
            if (status.isError()) {
                return this.fTestRunnerPart.fTestErrorIcon;
            }
            if (status.isFailure()) {
                switch (status.getFailedCode()) {
                    case 0: {
                        return this.fTestRunnerPart.fTestAbortedIcon;
                    }
                    case 2: {
                        return this.fTestRunnerPart.fTestBlockedIcon;
                    }
                    case 1: {
                        return this.fTestRunnerPart.fTestSkippedIcon;
                    }
                    case 3: {
                        return this.fTestRunnerPart.fTestUnknownIcon;
                    }
                }
                return this.fTestRunnerPart.fTestFailIcon;
            }
            if (status.isOK()) {
                return this.fTestRunnerPart.fTestOkIcon;
            }
            throw new IllegalStateException(element.toString());
        }
        if (element instanceof TestSuiteElement) {
            TestElement.Status status = ((TestSuiteElement)element).getStatus();
            if (status.isNotRun()) {
                return this.fTestRunnerPart.fSuiteIcon;
            }
            if (status.isRunning()) {
                return this.fTestRunnerPart.fSuiteRunningIcon;
            }
            if (status.isError()) {
                return this.fTestRunnerPart.fSuiteErrorIcon;
            }
            if (status.isFailure()) {
                switch (status.getFailedCode()) {
                    case 0: {
                        return this.fTestRunnerPart.fSuiteAbortedIcon;
                    }
                    case 2: {
                        return this.fTestRunnerPart.fSuiteBlockedIcon;
                    }
                    case 1: {
                        return this.fTestRunnerPart.fSuiteSkippedIcon;
                    }
                    case 3: {
                        return this.fTestRunnerPart.fSuiteUnknownIcon;
                    }
                }
                return this.fTestRunnerPart.fSuiteFailIcon;
            }
            if (status.isOK()) {
                return this.fTestRunnerPart.fSuiteOkIcon;
            }
            throw new IllegalStateException(element.toString());
        }
        throw new IllegalArgumentException(String.valueOf(element));
    }
}

