/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.CompletionContext;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.dltk.ui.text.completion.FieldProposalInfo;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.LazyScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.MethodProposalInfo;
import org.eclipse.dltk.ui.text.completion.ProposalContextInformation;
import org.eclipse.dltk.ui.text.completion.ProposalInfo;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.ScriptMethodCompletionProposal;
import org.eclipse.dltk.ui.text.completion.TypeProposalInfo;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;

public abstract class ScriptCompletionProposalCollector
extends CompletionRequestor {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.dltk.ui/debug/ResultCollector"));
    private CompletionProposalLabelProvider fLabelProvider;
    private final ImageDescriptorRegistry fRegistry = DLTKUIPlugin.getImageDescriptorRegistry();
    private final List fScriptProposals = new ArrayList();
    private final List fRawCompletionProposals = new ArrayList();
    private final List fKeywords = new ArrayList();
    private final Set fSuggestedMethodNames = new HashSet();
    private final ISourceModule fSourceModule;
    private final IScriptProject fScriptProject;
    private int fUserReplacementLength;
    private CompletionContext fContext;
    private IProblem fLastProblem;
    private long fStartTime;
    private long fUITime;
    private ScriptContentAssistInvocationContext fInvocationContext;

    public ScriptCompletionProposalCollector(ISourceModule cu) {
        this(cu.getScriptProject(), cu);
    }

    public ScriptCompletionProposalCollector(IScriptProject project) {
        this(project, null);
    }

    protected ScriptCompletionProposalCollector(IScriptProject project, ISourceModule cu) {
        this.fScriptProject = project;
        this.fSourceModule = cu;
        this.fUserReplacementLength = -1;
    }

    public void setInvocationContext(ScriptContentAssistInvocationContext context) {
        this.fInvocationContext = context;
        context.setCollector(this);
    }

    protected final ScriptContentAssistInvocationContext getInvocationContext() {
        if (this.fInvocationContext == null) {
            this.setInvocationContext(this.createScriptContentAssistInvocationContext(this.getSourceModule()));
        }
        return this.fInvocationContext;
    }

    protected ScriptContentAssistInvocationContext createScriptContentAssistInvocationContext(ISourceModule sourceModule) {
        return new ScriptContentAssistInvocationContext(sourceModule){

            protected CompletionProposalLabelProvider createLabelProvider() {
                return new CompletionProposalLabelProvider();
            }
        };
    }

    protected CompletionProposal[] getRawCompletionProposals() {
        return this.fRawCompletionProposals.toArray(new CompletionProposal[this.fRawCompletionProposals.size()]);
    }

    public void accept(CompletionProposal proposal) {
        long start = DEBUG ? System.currentTimeMillis() : 0L;
        try {
            if (this.isFiltered(proposal)) {
                return;
            }
            this.fRawCompletionProposals.add(proposal);
            if (proposal.getKind() == 9) {
                this.acceptPotentialMethodDeclaration(proposal);
            } else {
                IScriptCompletionProposal scriptProposal = this.createScriptCompletionProposal(proposal);
                if (scriptProposal != null) {
                    this.fScriptProposals.add(scriptProposal);
                    if (proposal.getKind() == 2) {
                        this.fKeywords.add(scriptProposal);
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            DLTKUIPlugin.log((IStatus)new Status(4, DLTKUIPlugin.getPluginId(), 0, "Exception when processing proposal for: " + String.valueOf(proposal.getCompletion()), (Throwable)e));
        }
        if (DEBUG) {
            this.fUITime += System.currentTimeMillis() - start;
        }
    }

    public void acceptContext(CompletionContext context) {
        this.fContext = context;
        this.getLabelProvider().setContext(context);
    }

    protected CompletionProposalLabelProvider createLabelProvider() {
        return new CompletionProposalLabelProvider();
    }

    protected CompletionProposalLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = this.createLabelProvider();
        }
        return this.fLabelProvider;
    }

    public void beginReporting() {
        if (DEBUG) {
            this.fStartTime = System.currentTimeMillis();
            this.fUITime = 0L;
        }
        this.fLastProblem = null;
        this.fScriptProposals.clear();
        this.fKeywords.clear();
        this.fSuggestedMethodNames.clear();
    }

    public void completionFailure(IProblem problem) {
        this.fLastProblem = problem;
    }

    public void endReporting() {
        if (DEBUG) {
            long total = System.currentTimeMillis() - this.fStartTime;
            System.err.println("Core Collector (core):\t" + (total - this.fUITime));
            System.err.println("Core Collector (ui):\t" + this.fUITime);
        }
    }

    public String getErrorMessage() {
        if (this.fLastProblem != null) {
            return this.fLastProblem.getMessage();
        }
        return "";
    }

    public final IScriptCompletionProposal[] getScriptCompletionProposals() {
        return this.fScriptProposals.toArray(new IScriptCompletionProposal[this.fScriptProposals.size()]);
    }

    public final IScriptCompletionProposal[] getKeywordCompletionProposals() {
        return this.fKeywords.toArray(new ScriptCompletionProposal[this.fKeywords.size()]);
    }

    public final void setReplacementLength(int length) {
        this.fUserReplacementLength = length;
    }

    protected int computeRelevance(CompletionProposal proposal) {
        int baseRelevance = proposal.getRelevance() * 16;
        switch (proposal.getKind()) {
            case 3: {
                return baseRelevance + 0;
            }
            case 2: {
                return baseRelevance + 1;
            }
            case 11: {
                return baseRelevance + 2;
            }
            case 7: {
                return baseRelevance + 2;
            }
            case 5: 
            case 6: 
            case 10: {
                return baseRelevance + 3;
            }
            case 9: {
                return baseRelevance + 3;
            }
            case 1: {
                return baseRelevance + 4;
            }
            case 4: 
            case 8: {
                return baseRelevance + 5;
            }
        }
        return baseRelevance;
    }

    protected IScriptCompletionProposal createScriptCompletionProposal(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 2: {
                return this.createKeywordProposal(proposal);
            }
            case 11: {
                return this.createPackageProposal(proposal);
            }
            case 7: {
                return this.createTypeProposal(proposal);
            }
            case 1: {
                return this.createFieldProposal(proposal);
            }
            case 5: 
            case 10: {
                return this.createMethodReferenceProposal(proposal);
            }
            case 6: {
                return this.createMethodDeclarationProposal(proposal);
            }
            case 3: {
                return this.createLabelProposal(proposal);
            }
            case 4: 
            case 8: {
                return this.createLocalVariableProposal(proposal);
            }
        }
        return null;
    }

    protected final IContextInformation createMethodContextInformation(CompletionProposal methodProposal) {
        Assert.isTrue((methodProposal.getKind() == 5 ? 1 : 0) != 0);
        return new ProposalContextInformation(methodProposal);
    }

    protected final ISourceModule getSourceModule() {
        return this.fSourceModule;
    }

    protected final CompletionContext getContext() {
        return this.fContext;
    }

    protected final Image getImage(ImageDescriptor descriptor) {
        return descriptor == null ? null : this.fRegistry.get(descriptor);
    }

    protected final int getLength(CompletionProposal proposal) {
        int length;
        int start = proposal.getReplaceStart();
        int end = proposal.getReplaceEnd();
        if (this.fUserReplacementLength == -1) {
            length = end - start;
        } else {
            length = this.fUserReplacementLength;
            int behindCompletion = proposal.getCompletionLocation() + 1;
            if (start < behindCompletion) {
                length += behindCompletion - start;
            }
        }
        return length;
    }

    protected boolean isFiltered(CompletionProposal proposal) {
        return this.isIgnored(proposal.getKind());
    }

    private void acceptPotentialMethodDeclaration(CompletionProposal proposal) {
        if (this.fSourceModule == null) {
            return;
        }
        try {
            IType type;
            IModelElement element = this.fSourceModule.getElementAt(proposal.getCompletionLocation() + 1);
            if (element != null && (type = (IType)element.getAncestor(7)) != null && DLTKCore.DEBUG) {
                System.out.println("TODO: Add method completion proposal support here...");
            }
        }
        catch (CoreException e) {
            DLTKUIPlugin.log(e);
        }
    }

    protected abstract ScriptCompletionProposal createScriptCompletionProposal(String var1, int var2, int var3, Image var4, String var5, int var6);

    protected abstract ScriptCompletionProposal createScriptCompletionProposal(String var1, int var2, int var3, Image var4, String var5, int var6, boolean var7);

    protected abstract ScriptCompletionProposal createOverrideCompletionProposal(IScriptProject var1, ISourceModule var2, String var3, String[] var4, int var5, int var6, String var7, String var8);

    private IScriptCompletionProposal createFieldProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        String label = this.getLabelProvider().createLabelWithTypeAndDeclaration(proposal);
        Image image = this.getImage(this.getLabelProvider().createFieldImageDescriptor(proposal));
        int relevance = this.computeRelevance(proposal);
        ScriptCompletionProposal scriptProposal = this.createScriptCompletionProposal(completion, start, length, image, label, relevance, false);
        if (this.fScriptProject != null) {
            scriptProposal.setProposalInfo(new FieldProposalInfo(this.fScriptProject, proposal));
        }
        scriptProposal.setTriggerCharacters(this.getVarTrigger());
        return scriptProposal;
    }

    protected IScriptCompletionProposal createKeywordProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        String label = this.getLabelProvider().createKeywordLabel(proposal);
        Image img = this.getImage(this.getLabelProvider().createImageDescriptor(proposal));
        int relevance = this.computeRelevance(proposal);
        ScriptCompletionProposal scriptProposal = this.createScriptCompletionProposal(completion, start, length, img, label, relevance);
        if (this.fScriptProject != null) {
            scriptProposal.setProposalInfo(new ProposalInfo(this.fScriptProject, new String(proposal.getName())));
        }
        return scriptProposal;
    }

    protected IScriptCompletionProposal createPackageProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        String label = this.getLabelProvider().createSimpleLabel(proposal);
        int relevance = this.computeRelevance(proposal);
        return this.createScriptCompletionProposal(completion, start, length, this.getImage(this.getLabelProvider().createImageDescriptor(proposal)), label, relevance);
    }

    private IScriptCompletionProposal createLabelProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        String label = this.getLabelProvider().createSimpleLabel(proposal);
        int relevance = this.computeRelevance(proposal);
        return this.createScriptCompletionProposal(completion, start, length, null, label, relevance);
    }

    private IScriptCompletionProposal createLocalVariableProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        Image image = this.getImage(this.getLabelProvider().createLocalImageDescriptor(proposal));
        String label = this.getLabelProvider().createSimpleLabelWithType(proposal);
        int relevance = this.computeRelevance(proposal);
        ScriptCompletionProposal javaProposal = this.createScriptCompletionProposal(completion, start, length, image, label, relevance);
        javaProposal.setTriggerCharacters(this.getVarTrigger());
        return javaProposal;
    }

    protected abstract char[] getVarTrigger();

    private IScriptCompletionProposal createMethodDeclarationProposal(CompletionProposal proposal) {
        if (this.fSourceModule == null || this.fScriptProject == null) {
            return null;
        }
        String name = String.valueOf(proposal.getName());
        String[] paramTypes = new String[]{};
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        String label = this.getLabelProvider().createOverrideMethodProposalLabel(proposal);
        ScriptCompletionProposal scriptProposal = this.createOverrideCompletionProposal(this.fScriptProject, this.fSourceModule, name, paramTypes, start, length, label, String.valueOf(proposal.getCompletion()));
        scriptProposal.setImage(this.getImage(this.getLabelProvider().createMethodImageDescriptor(proposal)));
        MethodProposalInfo info = new MethodProposalInfo(this.fScriptProject, proposal);
        scriptProposal.setProposalInfo(info);
        scriptProposal.setRelevance(this.computeRelevance(proposal));
        this.fSuggestedMethodNames.add(new String(name));
        return scriptProposal;
    }

    private IScriptCompletionProposal createMethodReferenceProposal(CompletionProposal methodProposal) {
        ScriptMethodCompletionProposal proposal = new ScriptMethodCompletionProposal(methodProposal, this.getInvocationContext());
        this.adaptLength(proposal, methodProposal);
        return proposal;
    }

    private void adaptLength(LazyScriptCompletionProposal proposal, CompletionProposal coreProposal) {
        if (this.fUserReplacementLength != -1) {
            proposal.setReplacementLength(this.getLength(coreProposal));
        }
    }

    private IScriptCompletionProposal createTypeProposal(CompletionProposal typeProposal) {
        String completion = new String(typeProposal.getCompletion());
        int replaceStart = typeProposal.getReplaceStart();
        int length = typeProposal.getReplaceEnd() - typeProposal.getReplaceStart() + 1;
        Image image = this.getImage(this.getLabelProvider().createTypeImageDescriptor(typeProposal));
        String displayString = this.getLabelProvider().createTypeProposalLabel(typeProposal);
        ScriptCompletionProposal scriptProposal = this.createScriptCompletionProposal(completion, replaceStart, length, image, displayString, 0);
        scriptProposal.setRelevance(this.computeRelevance(typeProposal));
        scriptProposal.setProposalInfo(new TypeProposalInfo(this.fScriptProject, typeProposal));
        return scriptProposal;
    }

    public boolean isContextInformationMode() {
        return this.fInvocationContext != null && this.fInvocationContext.isContextInformationMode();
    }
}

