/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core.parser;

import java.util.List;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclBodyDeclaration;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclMethodCallStatement;
import org.eclipse.dltk.tcl.core.extensions.ISourceElementRequestVisitorExtension;
import org.eclipse.dltk.tcl.internal.parser.TclSourceElementRequestVisitor;

public class IncrTclSourceElementRequestVisitorExtension
implements ISourceElementRequestVisitorExtension {
    public int getModifiers(Declaration s) {
        if ((s.getModifiers() & 0x200000) != 0) {
            return s.getModifiers();
        }
        return 0;
    }

    public boolean visit(Statement statement, TclSourceElementRequestVisitor original) {
        if (statement instanceof IncrTclMethodCallStatement) {
            CallArgumentsList arguments;
            List childs;
            IncrTclMethodCallStatement call = (IncrTclMethodCallStatement)statement;
            SimpleReference callName = call.getCallName();
            int len = 0;
            if (call.getArgs() != null && (childs = (arguments = call.getArgs()).getChilds()) != null) {
                len = childs.size();
            }
            original.getRequestor().acceptMethodReference(callName.getName().toCharArray(), len, call.sourceStart(), call.sourceEnd());
            return true;
        }
        return false;
    }

    public TclSourceElementRequestVisitor.ExitFromType getExitExtended(MethodDeclaration method, TclSourceElementRequestVisitor original) {
        String tName = method.getDeclaringTypeName();
        if (tName == null) {
            tName = "";
        }
        return original.resolveType((Declaration)method, String.valueOf(tName) + "::dummy", false);
    }

    public boolean extendedExitRequired(MethodDeclaration method, TclSourceElementRequestVisitor original) {
        return method instanceof IncrTclBodyDeclaration;
    }

    public TclSourceElementRequestVisitor.ExitFromType processField(FieldDeclaration decl, TclSourceElementRequestVisitor original) {
        MethodDeclaration method = original.getCurrentMethod();
        if (method != null && method instanceof IncrTclBodyDeclaration) {
            IncrTclBodyDeclaration body = (IncrTclBodyDeclaration)method;
            Declaration cfr_ignored_0 = (Declaration)body.getDeclaringType();
            return null;
        }
        return null;
    }

    public boolean skipMethod(MethodDeclaration method, TclSourceElementRequestVisitor tclSourceElementRequestVisitor) {
        return false;
    }
}

