/*
 * Decompiled with CFR 0.152.
 */
package com.xored.org.mozilla.javascript;

import com.xored.org.mozilla.javascript.FunctionObject;
import com.xored.org.mozilla.javascript.Kit;
import com.xored.org.mozilla.javascript.RhinoException;
import com.xored.org.mozilla.javascript.Scriptable;
import com.xored.org.mozilla.javascript.ScriptableObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class LazilyLoadedCtor {
    private static Method getter;
    private static Method setter;
    private String ctorName;
    private String className;
    private boolean sealed;
    private boolean isReplaced;

    public LazilyLoadedCtor(ScriptableObject scope, String ctorName, String className, boolean sealed) {
        this.className = className;
        this.ctorName = ctorName;
        this.sealed = sealed;
        if (getter == null) {
            Method[] methods = FunctionObject.getMethodList(this.getClass());
            getter = FunctionObject.findSingleMethod(methods, "getProperty");
            setter = FunctionObject.findSingleMethod(methods, "setProperty");
        }
        scope.defineProperty(ctorName, this, getter, setter, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(ScriptableObject obj) {
        ScriptableObject scriptableObject = obj;
        synchronized (scriptableObject) {
            if (!this.isReplaced) {
                boolean removeOnError = false;
                Class cl = Kit.classOrNull(this.className);
                if (cl == null) {
                    removeOnError = true;
                } else {
                    try {
                        ScriptableObject.defineClass(obj, cl, this.sealed);
                        this.isReplaced = true;
                    }
                    catch (InvocationTargetException ex) {
                        Throwable target = ex.getTargetException();
                        if (target instanceof RuntimeException) {
                            throw (RuntimeException)target;
                        }
                        removeOnError = true;
                    }
                    catch (RhinoException rhinoException) {
                        removeOnError = true;
                    }
                    catch (InstantiationException instantiationException) {
                        removeOnError = true;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        removeOnError = true;
                    }
                    catch (SecurityException securityException) {
                        removeOnError = true;
                    }
                    catch (LinkageError linkageError) {
                        removeOnError = true;
                    }
                }
                if (removeOnError) {
                    obj.delete(this.ctorName);
                    return Scriptable.NOT_FOUND;
                }
            }
        }
        return obj.get(this.ctorName, (Scriptable)obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setProperty(ScriptableObject obj, Object val) {
        ScriptableObject scriptableObject = obj;
        synchronized (scriptableObject) {
            this.isReplaced = true;
            return val;
        }
    }
}

