/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.folding;

import java.util.ArrayList;
import org.eclipse.core.runtime.ILog;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.internal.javascript.parser.JavaScriptSourceParser;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptPartitionScanner;
import org.eclipse.dltk.javascript.ui.text.IJavaScriptPartitions;
import org.eclipse.dltk.ui.text.folding.AbstractASTFoldingStructureProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class JavascriptFoldingStructureProvider
extends AbstractASTFoldingStructureProvider {
    private boolean fInitCollapseComments = true;
    private boolean fInitCollapseBlocks = true;
    private boolean fInitCollapseClasses = true;
    private boolean fFoldNewLines = true;

    protected void initializePreferences(IPreferenceStore store) {
        super.initializePreferences(store);
        this.fFoldNewLines = true;
        this.fInitCollapseBlocks = false;
        this.fInitCollapseComments = true;
        this.fInitCollapseClasses = false;
    }

    private void installDocumentStuff(Document document) {
        String[] types = new String[]{"__javascript_string", "__javascript_comment", "__dftl_partition_content_type"};
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new JavascriptPartitionScanner(), types);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("__javascript_partitioning", (IDocumentPartitioner)partitioner);
    }

    private void removeDocumentStuff(Document document) {
        document.setDocumentPartitioner("__javascript_partitioning", null);
    }

    private ITypedRegion getRegion(IDocument d, int offset) throws BadLocationException {
        return TextUtilities.getPartition((IDocument)d, (String)"__javascript_partitioning", (int)offset, (boolean)true);
    }

    /*
     * Unable to fully structure code
     */
    protected final IRegion[] computeCommentsRanges(String contents) {
        try {
            if (contents == null) {
                return new IRegion[0];
            }
            regions = new ArrayList<Region>();
            d = new Document(contents);
            this.installDocumentStuff(d);
            docRegionList = new ArrayList<ITypedRegion>();
            region = null;
            offset = 0;
            try {
                while (true) {
                    region = this.getRegion((IDocument)d, offset);
                    docRegionList.add(region);
                    offset = region.getLength() + region.getOffset() + 1;
                }
            }
            catch (BadLocationException v0) {
                docRegions = new ITypedRegion[docRegionList.size()];
                docRegionList.toArray(docRegions);
                fullRegion = null;
                start = -1;
                i = 0;
                ** while (i < docRegions.length)
            }
lbl-1000:
            // 1 sources

            {
                region = docRegions[i];
                multiline = this.isMultilineRegion((IDocument)d, (IRegion)region);
                badStart = false;
                if (d.getLineOffset(d.getLineOfOffset(region.getOffset())) != region.getOffset() && (lineStartStr = d.get(lineStart = d.getLineOffset(d.getLineOfOffset(region.getOffset())), region.getOffset() - lineStart)).trim().length() != 0) {
                    badStart = true;
                }
                if (!badStart && (region.getType().equals("__javascript_comment") || start != -1 && this.isEmptyRegion((IDocument)d, region) && multiline && this.collapseEmptyLines() || start != -1 && this.isEmptyRegion((IDocument)d, region) && !multiline)) {
                    if (start == -1) {
                        start = i;
                    }
                } else {
                    if (start != -1 && this.isMultilineRegion((IDocument)d, (IRegion)(fullRegion = new Region(offset0 = docRegions[start].getOffset(), length0 = docRegions[i - 1].getOffset() - offset0 + docRegions[i - 1].getLength() - 1)))) {
                        regions.add(fullRegion);
                    }
                    start = -1;
                }
                ++i;
                continue;
            }
lbl40:
            // 1 sources

            if (start != -1 && this.isMultilineRegion((IDocument)d, (IRegion)(fullRegion = new Region(offset0 = docRegions[start].getOffset(), length0 = docRegions[docRegions.length - 1].getOffset() - offset0 + docRegions[docRegions.length - 1].getLength() - 1)))) {
                regions.add(fullRegion);
            }
            this.removeDocumentStuff(d);
            result = new IRegion[regions.size()];
            regions.toArray(result);
            return result;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return new IRegion[0];
        }
    }

    protected AbstractASTFoldingStructureProvider.CodeBlock[] getCodeBlocks(String code) {
        return this.computeBlockRanges(0, code);
    }

    private AbstractASTFoldingStructureProvider.CodeBlock[] computeBlockRanges(final int offset, String contents) {
        ArrayList result;
        block2: {
            JavaScriptSourceParser pp = new JavaScriptSourceParser();
            ModuleDeclaration md = pp.parse(null, contents.toCharArray(), null);
            result = new ArrayList();
            ASTVisitor visitor = new ASTVisitor(){

                public boolean visit(MethodDeclaration s) throws Exception {
                    result.add(new AbstractASTFoldingStructureProvider.CodeBlock((AbstractASTFoldingStructureProvider)JavascriptFoldingStructureProvider.this, (ASTNode)s, (IRegion)new Region(offset + s.sourceStart(), s.sourceEnd() - s.sourceStart())));
                    return super.visit(s);
                }

                public boolean visit(TypeDeclaration s) throws Exception {
                    result.add(new AbstractASTFoldingStructureProvider.CodeBlock((AbstractASTFoldingStructureProvider)JavascriptFoldingStructureProvider.this, (ASTNode)s, (IRegion)new Region(offset + s.sourceStart(), s.sourceEnd() - s.sourceStart())));
                    return super.visit(s);
                }
            };
            try {
                md.traverse(visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return result.toArray(new AbstractASTFoldingStructureProvider.CodeBlock[result.size()]);
    }

    protected boolean initiallyCollapse(ASTNode s, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        return false;
    }

    protected boolean initiallyCollapseComments(AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        return ctx.allowCollapsing() && this.fInitCollapseComments;
    }

    protected boolean mayCollapse(ASTNode s, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        return true;
    }

    protected boolean collapseEmptyLines() {
        return this.fFoldNewLines;
    }

    protected String getCommentPartition() {
        return "__javascript_comment";
    }

    protected ILog getLog() {
        return JavaScriptUI.getDefault().getLog();
    }

    protected String getPartition() {
        return "__javascript_partitioning";
    }

    protected IPartitionTokenScanner getPartitionScanner() {
        return new JavascriptPartitionScanner();
    }

    protected String[] getPartitionTypes() {
        return IJavaScriptPartitions.JS_PARTITION_TYPES;
    }

    protected String getNatureId() {
        return "org.eclipse.dltk.javascript.core.nature";
    }

    protected boolean initiallyCollapse(Statement s, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        return false;
    }

    protected boolean mayCollapse(Statement s, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        return false;
    }
}

