/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.reference.resolvers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.javascript.reference.resolvers.IReferenceResolver;
import org.eclipse.dltk.internal.javascript.reference.resolvers.IResolvableReference;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;

public final class ReferenceResolverContext {
    protected ArrayList resolvers = new ArrayList();
    protected ISourceModule module;
    protected Map settings;
    private HostCollection collection;

    public ReferenceResolverContext(ISourceModule module, Map settings) {
        this.module = module;
        this.settings = settings;
    }

    public ISourceModule getModule() {
        return this.module;
    }

    public Map getOptions() {
        return this.settings;
    }

    public boolean resolveLocals() {
        return false;
    }

    public Set resolveGlobals(String id) {
        HashSet sm = new HashSet();
        int a = 0;
        while (a < this.resolvers.size()) {
            IReferenceResolver res = (IReferenceResolver)this.resolvers.get(a);
            Set result = res.resolveGlobals(id);
            sm.addAll(result);
            ++a;
        }
        return sm;
    }

    public void init() {
        int a = 0;
        while (a < this.resolvers.size()) {
            IReferenceResolver res = (IReferenceResolver)this.resolvers.get(a);
            res.init(this);
            ++a;
        }
    }

    public Set resolveChilds(IResolvableReference abstractCallResultReference) {
        int a = 0;
        while (a < this.resolvers.size()) {
            IReferenceResolver res = (IReferenceResolver)this.resolvers.get(a);
            Set result = res.getChilds(abstractCallResultReference);
            if (result != null && !result.isEmpty()) {
                return result;
            }
            ++a;
        }
        return new HashSet();
    }

    public void processCall(String call, String objId) {
        int a = 0;
        while (a < this.resolvers.size()) {
            IReferenceResolver res = (IReferenceResolver)this.resolvers.get(a);
            res.processCall(call, objId);
            ++a;
        }
    }

    public HostCollection getHostCollection() {
        return this.collection;
    }

    public void setHostCollection(HostCollection collection) {
        this.collection = collection;
    }
}

