/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist;

import com.xored.org.mozilla.javascript.CompilerEnvirons;
import com.xored.org.mozilla.javascript.Parser;
import com.xored.org.mozilla.javascript.ScriptOrFnNode;
import java.util.HashMap;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ResolverManager;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.PositionReachedException;
import org.eclipse.dltk.internal.javascript.typeinference.TypeInferencer;
import org.eclipse.dltk.javascript.internal.core.codeassist.NullReporter;

public class AssitUtils {
    public static ReferenceResolverContext buildContext(ISourceModule module, int position, String content, char[] fileName2) {
        HashMap settings = new HashMap();
        ReferenceResolverContext createResolverContext = ResolverManager.createResolverContext(module, settings);
        Parser p = new Parser(new CompilerEnvirons(), new NullReporter());
        ScriptOrFnNode parse = p.parse(content, new String(fileName2), 0);
        TypeInferencer inf = new TypeInferencer((ModelElement)module, createResolverContext);
        try {
            inf.doInterferencing(parse, position);
        }
        catch (PositionReachedException positionReachedException) {}
        createResolverContext.init();
        HostCollection collection = inf.getCollection();
        createResolverContext.setHostCollection(collection);
        return createResolverContext;
    }

    public static class PositionCalculator {
        private boolean isMember = false;
        private boolean needDot = false;
        private int lastDot = -1;
        private int nestLevel = 0;
        private int position;
        private int pos;
        private String content;

        public PositionCalculator(String conString, int pos, boolean bothSides) {
            this.position = pos;
            this.pos = this.calculatePos(conString, pos, bothSides);
            this.content = conString;
            if (this.position > conString.length()) {
                this.position = conString.length();
            }
        }

        public String getCompletion() {
            return this.content.substring(this.pos, this.position).trim();
        }

        private int calculatePos(String content, int pos, boolean bothSides) {
            int k = pos;
            if (bothSides) {
                int maxPos = content.length() - 1;
                if (pos < maxPos) {
                    while (pos < maxPos) {
                        char charAt;
                        if ((charAt = content.charAt(++pos)) == ']') {
                            ++this.nestLevel;
                            continue;
                        }
                        if (charAt == '[') {
                            --this.nestLevel;
                            continue;
                        }
                        if (this.nestLevel > 0) continue;
                        if (Character.isWhitespace(charAt)) {
                            ++pos;
                            break;
                        }
                        if (!this.needDot && Character.isJavaIdentifierPart(charAt)) continue;
                        ++pos;
                        break;
                    }
                    this.position = pos - 1;
                } else {
                    this.position = pos + 1;
                }
            }
            pos = k;
            while (pos > 0) {
                char charAt;
                if ((charAt = content.charAt(--pos)) == ']') {
                    ++this.nestLevel;
                    continue;
                }
                if (charAt == '[') {
                    --this.nestLevel;
                    continue;
                }
                if (this.nestLevel > 0) continue;
                if (Character.isWhitespace(charAt)) {
                    this.needDot = true;
                    continue;
                }
                if (charAt == '.') {
                    this.isMember = true;
                    this.needDot = false;
                    if (this.lastDot != -1) continue;
                    this.lastDot = pos + 1;
                    continue;
                }
                if (!this.needDot && Character.isJavaIdentifierPart(charAt)) continue;
                ++pos;
                break;
            }
            return pos;
        }

        public String getCompletionPart() {
            return this.content.substring(this.lastDot, this.position).trim();
        }

        public String getCorePart() {
            return this.content.substring(this.pos, this.lastDot - 1).trim();
        }

        public boolean isMember() {
            return this.isMember;
        }
    }
}

