/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.ui;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.internal.ui.editor.SemanticHighlightingManager;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.Highlighting;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlighting;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlightingPresenter;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.internal.ui.text.TclTextTools;
import org.eclipse.dltk.tcl.ui.semantilhighlighting.ISemanticHighlightingExtension;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclDocumentationNode;

public class XOTclSemanticHighlightingExtension
implements ISemanticHighlightingExtension {
    private SemanticHighlighting[] highlightings = new SemanticHighlighting[]{new TclTextTools.SH("DLTK_single_line_comment", null)};

    public SemanticHighlightingManager.HighlightedPosition[] calculatePositions(ASTNode node, SemanticHighlightingPresenter presenter, Highlighting[] highlightings) {
        Highlighting highlightingFrom = this.getHighlightingFrom(this.highlightings[0], highlightings);
        if (node instanceof TclStatement) {
            TclStatement st = (TclStatement)node;
            if (st.getAt(0) instanceof SimpleReference && ((SimpleReference)st.getAt(0)).getName().equals("@")) {
                Highlighting hl = highlightingFrom;
                return new SemanticHighlightingManager.HighlightedPosition[]{presenter.createHighlightedPosition(st.sourceStart(), st.sourceEnd() - st.sourceStart(), hl)};
            }
        } else if (node instanceof XOTclDocumentationNode) {
            return new SemanticHighlightingManager.HighlightedPosition[]{presenter.createHighlightedPosition(node.sourceStart(), node.sourceEnd() - node.sourceStart(), highlightingFrom)};
        }
        return new SemanticHighlightingManager.HighlightedPosition[0];
    }

    private Highlighting getHighlightingFrom(SemanticHighlighting semanticHighlighting, Highlighting[] highlightings2) {
        int i = 0;
        while (i < highlightings2.length) {
            if (highlightings2[i].getSemaHighlighting().equals(semanticHighlighting)) {
                return highlightings2[i];
            }
            ++i;
        }
        return null;
    }

    public SemanticHighlighting[] getHighlightings() {
        return this.highlightings;
    }
}

