/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.commands;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.exceptions.DbgpIOException;
import org.eclipse.dltk.dbgp.exceptions.DbgpOpertionCanceledException;
import org.eclipse.dltk.dbgp.exceptions.DbgpTimeoutException;
import org.eclipse.dltk.dbgp.internal.DbgpRequest;
import org.eclipse.dltk.dbgp.internal.IDbgpDebugingEngine;
import org.eclipse.dltk.dbgp.internal.commands.IDbgpCommunicator;
import org.eclipse.dltk.dbgp.internal.packets.DbgpResponsePacket;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlParser;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.DebugOption;
import org.eclipse.dltk.debug.core.IDebugOptions;
import org.w3c.dom.Element;

public class DbgpDebuggingEngineCommunicator
implements IDbgpCommunicator {
    private final int timeout;
    private final IDbgpDebugingEngine engine;
    private IDebugOptions options;
    private final Map activeRequests = new IdentityHashMap();
    private static final boolean DEBUG = false;

    private void sendRequest(String command) throws IOException {
        this.engine.sendCommand(command);
    }

    private DbgpResponsePacket receiveResponse(int transactionId) throws IOException, InterruptedException {
        return this.engine.getResponsePacket(transactionId, this.timeout);
    }

    public DbgpDebuggingEngineCommunicator(IDbgpDebugingEngine engine, IDebugOptions options) {
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        this.engine = engine;
        this.options = options;
        this.timeout = DLTKDebugPlugin.getDefault().getPluginPreferences().getInt("dbgp_response_timeout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Element communicate(DbgpRequest request) throws DbgpException {
        try {
            block20: {
                requestId = Integer.parseInt(request.getOption("-i"));
                if (this.options.get(DebugOption.DBGP_ASYNC) || request.isAsync()) {
                    this.sendRequest(request.toString());
                    packet = this.receiveResponse(requestId);
                } else {
                    var4_5 = this.activeRequests;
                    synchronized (var4_5) {
                        while (true) {
                            if (this.activeRequests.isEmpty()) {
                                this.activeRequests.put(request, request);
                                break;
                            }
                            this.activeRequests.wait();
                        }
                    }
                    try {
                        this.sendRequest(request.toString());
                        packet = this.receiveResponse(requestId);
                    }
                    catch (Throwable var5_6) {
                        var4_5 = null;
                        var6_8 = this.activeRequests;
                        synchronized (var6_8) {
                            this.activeRequests.remove(request);
                            this.activeRequests.notifyAll();
                            throw var5_6;
                        }
                    }
                    {
                        var4_5 = null;
                        var6_9 = this.activeRequests;
                    }
                    synchronized (var6_9) {
                        ** try [egrp 3[TRYBLOCK] [4 : 136->160)] { 
lbl40:
                        // 1 sources

                        this.activeRequests.remove(request);
                        this.activeRequests.notifyAll();
                    }
                }
                break block20;
lbl-1000:
                // 1 sources

                {
                    catch (Throwable v2) {
                        throw v2;
                    }
                }
            }
            if (packet == null) {
                throw new DbgpTimeoutException();
            }
            response = packet.getContent();
            e = DbgpXmlParser.checkError(response);
            if (e == null) return response;
            throw e;
        }
        catch (InterruptedException v3) {
            throw new DbgpOpertionCanceledException();
        }
        catch (IOException e) {
            throw new DbgpIOException(e);
        }
    }

    public void send(DbgpRequest request) throws DbgpException {
        try {
            this.sendRequest(request.toString());
        }
        catch (IOException e) {
            throw new DbgpIOException(e);
        }
    }

    public void configure(IDebugOptions debugOptions) {
        this.options = debugOptions;
    }
}

