/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.ui;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.validators.internal.core.ValidatorUtils;
import org.eclipse.dltk.validators.ui.Messages;
import org.eclipse.dltk.validators.ui.ValidatorConsoleTrackerManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.IPatternMatchListener;

public abstract class AbstractValidateSelectionWithConsole
implements IObjectActionDelegate {
    ISelection selection;

    protected abstract void invoceValidationFor(OutputStream var1, List var2, List var3, IProgressMonitor var4);

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.selection == null) {
            return;
        }
        this.processSelectionToElements(this.selection);
    }

    protected void processSelectionToElements(ISelection selection) {
        final HashSet elements = new HashSet();
        final HashSet resources = new HashSet();
        if (this.selection != null && this.selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)this.selection;
            Iterator iterator = sel.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                ValidatorUtils.processResourcesToElements(o, elements, resources);
            }
        }
        Job job = new Job(this.getJobName()){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                IOConsoleOutputStream newOutputStream = null;
                try {
                    if (AbstractValidateSelectionWithConsole.this.isConsoleRequired()) {
                        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
                        IOConsole ioConsole = new IOConsole(AbstractValidateSelectionWithConsole.this.getConsoleName(), null);
                        IPatternMatchListener[] listeners = ValidatorConsoleTrackerManager.getListeners();
                        int i = 0;
                        while (true) {
                            if (i >= listeners.length) {
                                consoleManager.addConsoles(new IConsole[]{ioConsole});
                                consoleManager.showConsoleView((IConsole)ioConsole);
                                newOutputStream = ioConsole.newOutputStream();
                                break;
                            }
                            ioConsole.addPatternMatchListener(listeners[i]);
                            ++i;
                        }
                    }
                    ArrayList els = new ArrayList();
                    els.addAll(elements);
                    ArrayList res = new ArrayList();
                    res.addAll(resources);
                    AbstractValidateSelectionWithConsole.this.invoceValidationFor((OutputStream)newOutputStream, els, res, monitor);
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    try {
                        if (newOutputStream == null) throw throwable;
                        newOutputStream.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                {
                    Object var7_9 = null;
                }
                try {}
                catch (IOException e) {
                    e.printStackTrace();
                    return Status.OK_STATUS;
                }
                if (newOutputStream == null) return Status.OK_STATUS;
                newOutputStream.close();
                return Status.OK_STATUS;
            }
        };
        HashSet resourcesOnly = new HashSet();
        resourcesOnly.addAll(resources);
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            ISourceModule module = (ISourceModule)iterator.next();
            resourcesOnly.add(module.getResource());
        }
        ISchedulingRule[] rules = resourcesOnly.toArray(new ISchedulingRule[resourcesOnly.size()]);
        job.setRule(MultiRule.combine((ISchedulingRule[])rules));
        job.setUser(true);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    protected abstract String getJobName();

    protected String getConsoleName() {
        String message = Messages.AbstractValidateSelectionWithConsole_dltkValidatorOutput;
        return NLS.bind((String)message, (Object)this.getJobName());
    }

    protected boolean isConsoleRequired() {
        return true;
    }
}

