/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core.parser.processors;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.itcl.internal.core.parser.IncrTclCommandDetector;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclExInstanceVariable;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclInstanceVariable;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;

public class IncrTclClassNewInstanceCommandProcessor
extends AbstractTclCommandProcessor {
    public ASTNode process(TclStatement statement, ITclParser parser, ASTNode parent) {
        Object param = this.getDetectedParameter();
        if (param == null || !(param instanceof TypeDeclaration) && !(param instanceof IncrTclCommandDetector.IncrTclGlobalClassParameter)) {
            return null;
        }
        if (statement.getCount() == 1) {
            return null;
        }
        Expression e = statement.getAt(1);
        String name = IncrTclClassNewInstanceCommandProcessor.extractSimpleReference((ASTNode)e);
        if (name == null) {
            this.report(parser, "A instance ame expected after class name.", (ASTNode)e, 1);
            return null;
        }
        if (param instanceof TypeDeclaration) {
            TypeDeclaration type = (TypeDeclaration)param;
            IncrTclInstanceVariable var = new IncrTclInstanceVariable(name, e.sourceStart(), e.sourceEnd(), statement.sourceStart(), statement.sourceEnd());
            var.setClassInstanceName((SimpleReference)statement.getAt(0));
            var.setDeclaringType(type);
            var.setModifier(0x200000);
            this.addToParent(parent, (ASTNode)var);
            return var;
        }
        IncrTclCommandDetector.IncrTclGlobalClassParameter classParam = (IncrTclCommandDetector.IncrTclGlobalClassParameter)param;
        IncrTclExInstanceVariable var = new IncrTclExInstanceVariable(name, e.sourceStart(), e.sourceEnd(), statement.sourceStart(), statement.sourceEnd());
        var.setClassInstanceName((SimpleReference)statement.getAt(0));
        var.setDeclaringClassParameter(classParam);
        var.setModifier(0x200000);
        this.addToParent(parent, (ASTNode)var);
        return var;
    }
}

