/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.launching;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.launching.AbstractInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.IInterpreterRunner;
import org.eclipse.dltk.launching.ScriptLaunchUtil;
import org.eclipse.dltk.tcl.internal.launching.TclInterpreterRunner;
import org.eclipse.dltk.tcl.launching.TclLaunchingPlugin;
import org.osgi.framework.Bundle;

public class GenericTclInstall
extends AbstractInterpreterInstall {
    BuiltinsHelper helper = null;

    public GenericTclInstall(IInterpreterInstallType type, String id) {
        super(type, id);
    }

    public IInterpreterRunner getInterpreterRunner(String mode) {
        IInterpreterRunner runner = super.getInterpreterRunner(mode);
        if (runner != null) {
            return runner;
        }
        if (mode.equals("run")) {
            return new TclInterpreterRunner((IInterpreterInstall)this);
        }
        return null;
    }

    public String getNatureId() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    public String getBuiltinModuleContent(String name) {
        this.initialize();
        return this.helper.source.toString();
    }

    public long lastModified() {
        this.initialize();
        return this.helper.lastModified;
    }

    private synchronized void initialize() {
        if (this.helper == null) {
            this.helper = new BuiltinsHelper();
            this.helper.load();
        }
    }

    public String[] getBuiltinModules() {
        return new String[]{"builtins.tcl"};
    }

    public class BuiltinsHelper {
        StringBuffer source = new StringBuffer();
        long lastModified;

        void load() {
            block2: {
                Job loadTclBuiltin = new Job(this, "Generate Tcl builtin file..."){
                    final /* synthetic */ BuiltinsHelper this$1;
                    {
                        this.this$1 = builtinsHelper;
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask("Generate Tcl builtin file", -1);
                        IExecutionEnvironment exeEnv = BuiltinsHelper.access$0(this.this$1).getExecEnvironment();
                        if (exeEnv == null) {
                            return Status.CANCEL_STATUS;
                        }
                        String bundlePath = "scripts/builtins.tcl";
                        String content = ScriptLaunchUtil.runEmbeddedScriptReadContent((IExecutionEnvironment)exeEnv, (String)bundlePath, (Bundle)TclLaunchingPlugin.getDefault().getBundle(), (IFileHandle)BuiltinsHelper.access$0(this.this$1).getInstallLocation(), (IProgressMonitor)monitor);
                        if (content != null) {
                            this.this$1.source.append(content);
                        }
                        this.this$1.lastModified = System.currentTimeMillis();
                        return Status.OK_STATUS;
                    }
                };
                loadTclBuiltin.schedule();
                try {
                    loadTclBuiltin.join();
                }
                catch (InterruptedException e) {
                    if (!DLTKCore.DEBUG) break block2;
                    e.printStackTrace();
                }
            }
        }

        static /* synthetic */ GenericTclInstall access$0(BuiltinsHelper builtinsHelper) {
            return builtinsHelper.GenericTclInstall.this;
        }
    }
}

