/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.dltk.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.dltk.internal.corext.refactoring.participants.ScriptProcessors;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.dltk.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.dltk.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.dltk.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.dltk.internal.corext.util.Resources;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public final class ScriptMoveProcessor
extends MoveProcessor
implements IScriptableRefactoring,
ICommentProvider,
IQualifiedNameUpdating,
IReorgDestinationValidator {
    private IReorgQueries fReorgQueries;
    private IReorgPolicy.IMovePolicy fMovePolicy;
    private ICreateTargetQueries fCreateTargetQueries;
    private boolean fWasCanceled;
    private String fComment;
    public static final String IDENTIFIER = "org.eclipse.dltk.ui.MoveProcessor";

    public ScriptMoveProcessor(IReorgPolicy.IMovePolicy policy) {
        this.fMovePolicy = policy;
    }

    protected Object getDestination() {
        IModelElement je = this.fMovePolicy.getScriptElementDestination();
        if (je != null) {
            return je;
        }
        return this.fMovePolicy.getResourceDestination();
    }

    public Object[] getElements() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(Arrays.asList(this.fMovePolicy.getScriptElements()));
        result.addAll(Arrays.asList(this.fMovePolicy.getResources()));
        return result.toArray();
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return this.fMovePolicy.canEnable();
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return this.fMovePolicy.loadParticipants(status, (RefactoringProcessor)this, this.getAffectedProjectNatures(), shared);
    }

    private String[] getAffectedProjectNatures() throws CoreException {
        String[] jNatures = ScriptProcessors.computeAffectedNaturs(this.fMovePolicy.getScriptElements());
        String[] rNatures = ResourceProcessors.computeAffectedNatures(this.fMovePolicy.getResources());
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(jNatures));
        result.addAll(Arrays.asList(rNatures));
        return result.toArray(new String[result.size()]);
    }

    public boolean wasCanceled() {
        return this.fWasCanceled;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 1);
        try {
            RefactoringStatus result = new RefactoringStatus();
            result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(this.fMovePolicy.getResources()))));
            IResource[] javaResources = ReorgUtils.getResources(this.fMovePolicy.getScriptElements());
            result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(javaResources))));
            refactoringStatus = result;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    public Object getCommonParentForInputElements() {
        return new ParentChecker(this.fMovePolicy.getResources(), this.fMovePolicy.getScriptElements()).getCommonParent();
    }

    public IModelElement[] getScriptElements() {
        return this.fMovePolicy.getScriptElements();
    }

    public IResource[] getResources() {
        return this.fMovePolicy.getResources();
    }

    public RefactoringStatus setDestination(IModelElement destination) throws ModelException {
        return this.fMovePolicy.setDestination(destination);
    }

    public RefactoringStatus setDestination(IResource destination) throws ModelException {
        return this.fMovePolicy.setDestination(destination);
    }

    public boolean canChildrenBeDestinations(IModelElement modelElement) {
        return this.fMovePolicy.canChildrenBeDestinations(modelElement);
    }

    public boolean canChildrenBeDestinations(IResource resource) {
        return this.fMovePolicy.canChildrenBeDestinations(resource);
    }

    public boolean canElementBeDestination(IModelElement modelElement) {
        return this.fMovePolicy.canElementBeDestination(modelElement);
    }

    public boolean canElementBeDestination(IResource resource) {
        return this.fMovePolicy.canElementBeDestination(resource);
    }

    public void setReorgQueries(IReorgQueries queries) {
        Assert.isNotNull((Object)queries);
        this.fReorgQueries = queries;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            Assert.isNotNull((Object)this.fReorgQueries);
            this.fWasCanceled = false;
            return this.fMovePolicy.checkFinalConditions(pm, context, this.fReorgQueries);
        }
        catch (OperationCanceledException e) {
            this.fWasCanceled = true;
            throw e;
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        DynamicValidationStateChange dynamicValidationStateChange;
        Assert.isTrue((this.fMovePolicy.getScriptElementDestination() == null || this.fMovePolicy.getResourceDestination() == null ? 1 : 0) != 0);
        Assert.isTrue((this.fMovePolicy.getScriptElementDestination() != null || this.fMovePolicy.getResourceDestination() != null ? 1 : 0) != 0);
        try {
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.ScriptMoveProcessor_change_name){

                public Change perform(IProgressMonitor pm2) throws CoreException {
                    Change change = super.perform(pm2);
                    Change[] changes = this.getChildren();
                    int index = 0;
                    while (index < changes.length) {
                        if (!(changes[index] instanceof TextEditBasedChange)) {
                            return null;
                        }
                        ++index;
                    }
                    return change;
                }
            };
            Change change = this.fMovePolicy.createChange(pm);
            if (change instanceof CompositeChange) {
                CompositeChange subComposite = (CompositeChange)change;
                result.merge(subComposite);
            } else {
                result.add(change);
            }
            dynamicValidationStateChange = result;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return dynamicValidationStateChange;
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        return this.fMovePolicy.postCreateChange(participantChanges, pm);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.MoveRefactoring_0;
    }

    public boolean canUpdateReferences() {
        return this.fMovePolicy.canUpdateReferences();
    }

    public void setUpdateReferences(boolean update) {
        this.fMovePolicy.setUpdateReferences(update);
    }

    public boolean getUpdateReferences() {
        if (!this.canUpdateReferences()) {
            return false;
        }
        return this.fMovePolicy.getUpdateReferences();
    }

    public boolean canEnableQualifiedNameUpdating() {
        return this.fMovePolicy.canEnableQualifiedNameUpdating();
    }

    public boolean canUpdateQualifiedNames() {
        return this.fMovePolicy.canUpdateQualifiedNames();
    }

    public String getFilePatterns() {
        return this.fMovePolicy.getFilePatterns();
    }

    public boolean getUpdateQualifiedNames() {
        return this.fMovePolicy.getUpdateQualifiedNames();
    }

    public void setFilePatterns(String patterns) {
        this.fMovePolicy.setFilePatterns(patterns);
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fMovePolicy.setUpdateQualifiedNames(update);
    }

    public boolean hasAllInputSet() {
        return this.fMovePolicy.hasAllInputSet();
    }

    public boolean hasDestinationSet() {
        return this.fMovePolicy.getScriptElementDestination() != null || this.fMovePolicy.getResourceDestination() != null;
    }

    public void setCreateTargetQueries(ICreateTargetQueries queries) {
        Assert.isNotNull((Object)queries);
        this.fCreateTargetQueries = queries;
    }

    public ICreateTargetQuery getCreateTargetQuery() {
        return this.fMovePolicy.getCreateTargetQuery(this.fCreateTargetQueries);
    }

    public boolean isTextualMove() {
        return this.fMovePolicy.isTextualMove();
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        return null;
    }

    public boolean canEnableComment() {
        return true;
    }

    public String getComment() {
        return this.fComment;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }
}

