/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.problem;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.Messages;
import org.eclipse.dltk.compiler.task.DLTKTaskReporter;
import org.eclipse.dltk.core.DLTKCore;

public class DLTKProblemReporter
implements IProblemReporter {
    private IResource resource;
    private IProblemFactory factory;
    private boolean cleaned = false;
    static /* synthetic */ Class class$0;

    protected IMarker reportProblem(IResource res, int line, int start, int end, String msg, int severity, int priority) throws CoreException {
        IMarker m = res.createMarker("org.eclipse.dltk.core.problem");
        m.setAttribute("lineNumber", line + 1);
        m.setAttribute("message", (Object)msg);
        m.setAttribute("severity", severity);
        m.setAttribute("priority", priority);
        m.setAttribute("charStart", start);
        m.setAttribute("charEnd", end);
        return m;
    }

    public IMarker reportProblem(IProblem problem) throws CoreException {
        int severity = 0;
        if (problem.isError()) {
            severity = 2;
        } else if (problem.isWarning()) {
            severity = 1;
        }
        return this.reportProblem(this.resource, problem.getSourceLineNumber(), problem.getSourceStart(), problem.getSourceEnd(), problem.getMessage(), severity, 1);
    }

    protected IProblemFactory getProblemFactory() {
        return this.factory;
    }

    public DLTKProblemReporter(IResource resource, IProblemFactory factory) {
        if (resource == null) {
            throw new NullPointerException(Messages.DLTKProblemReporter_resourceCannotBeNull);
        }
        if (factory == null) {
            throw new NullPointerException(Messages.DLTKProblemReporter_factoryCannotBeNull);
        }
        this.resource = resource;
        this.factory = factory;
    }

    public void reportTestProblem() {
        DefaultProblem problem = new DefaultProblem("originatingFileName", "message", 0, null, 0, 0, 1, 0, 0);
        try {
            this.reportProblem(problem);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void clearMarkers() {
        if (this.resource != null) {
            block3: {
                try {
                    this.resource.deleteMarkers("org.eclipse.dltk.core.problem", true, 2);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
            this.cleaned = true;
        }
    }

    public boolean isMarkersCleaned() {
        return this.cleaned;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.compiler.task.ITaskReporter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return new DLTKTaskReporter(this.resource);
        }
        return null;
    }
}

