/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElementDelta;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelOperation;
import org.eclipse.dltk.internal.core.SourceModule;

public class BecomeWorkingCopyOperation
extends ModelOperation {
    IProblemRequestor problemRequestor;
    IProblemReporter problemReporter;

    public BecomeWorkingCopyOperation(SourceModule workingCopy, IProblemRequestor problemRequestor) {
        super(new IModelElement[]{workingCopy});
        this.problemRequestor = problemRequestor;
    }

    public BecomeWorkingCopyOperation(SourceModule workingCopy, IProblemRequestor problemRequestor, IProblemReporter problemReporter) {
        this(workingCopy, problemRequestor);
        this.problemReporter = problemReporter;
    }

    protected void executeOperation() throws ModelException {
        SourceModule workingCopy = this.getWorkingCopy();
        ModelManager.PerWorkingCopyInfo perWorkingCopyInfo = ModelManager.getModelManager().getPerWorkingCopyInfo(workingCopy, true, true, this.problemRequestor, this.problemReporter);
        perWorkingCopyInfo.noProblemReporter = true;
        workingCopy.openWhenClosed(workingCopy.createElementInfo(), this.progressMonitor);
        perWorkingCopyInfo.noProblemReporter = false;
        if (!workingCopy.isPrimary()) {
            ModelElementDelta delta = new ModelElementDelta(this.getModel());
            delta.added(workingCopy);
            this.addDelta(delta);
        } else if (workingCopy.getResource().isAccessible()) {
            ModelElementDelta delta = new ModelElementDelta(this.getModel());
            delta.changed(workingCopy, 65536);
            this.addDelta(delta);
        } else {
            ModelElementDelta delta = new ModelElementDelta(this.getModel());
            delta.added(workingCopy, 65536);
            this.addDelta(delta);
        }
        this.resultElements = new IModelElement[]{workingCopy};
    }

    protected SourceModule getWorkingCopy() {
        return (SourceModule)this.getElementToProcess();
    }

    public boolean isReadOnly() {
        return true;
    }
}

