/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.PackageDeclaration;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.dltk.internal.core.SourceFieldElementInfo;
import org.eclipse.dltk.internal.core.SourceMethod;
import org.eclipse.dltk.internal.core.SourceMethodElementInfo;
import org.eclipse.dltk.internal.core.SourceModuleElementInfo;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.internal.core.SourceRefElementInfo;
import org.eclipse.dltk.internal.core.SourceType;
import org.eclipse.dltk.internal.core.SourceTypeElementInfo;

public class SourceModuleStructureRequestor
implements ISourceElementRequestor {
    private static final String[] EMPTY = new String[0];
    private ISourceModule module;
    private SourceModuleElementInfo moduleInfo;
    private Map newElements;
    private Stack infoStack;
    private Stack handleStack;
    protected boolean hasSyntaxErrors = false;

    SourceModuleStructureRequestor(ISourceModule module, SourceModuleElementInfo moduleInfo, Map newElements) {
        this.module = module;
        this.moduleInfo = moduleInfo;
        this.newElements = newElements;
    }

    protected void resolveDuplicates(SourceRefElement handle) {
        while (this.newElements.containsKey(handle)) {
            ++handle.occurrenceCount;
        }
    }

    public void enterModule() {
        this.infoStack = new Stack();
        this.handleStack = new Stack();
        this.enterModuleRoot();
    }

    public void enterModuleRoot() {
        this.infoStack.push(this.moduleInfo);
        this.handleStack.push(this.module);
    }

    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        ModelElementInfo parentInfo = (ModelElementInfo)this.infoStack.peek();
        ModelElement parentHandle = (ModelElement)this.handleStack.peek();
        this.createField(fieldInfo, parentInfo, parentHandle);
    }

    private void createField(ISourceElementRequestor.FieldInfo fieldInfo, ModelElementInfo parentInfo, ModelElement parentHandle) {
        ModelManager manager = ModelManager.getModelManager();
        SourceField handle = new SourceField(parentHandle, manager.intern(fieldInfo.name));
        this.resolveDuplicates(handle);
        SourceFieldElementInfo info = new SourceFieldElementInfo();
        info.setNameSourceStart(fieldInfo.nameSourceStart);
        info.setNameSourceEnd(fieldInfo.nameSourceEnd);
        info.setSourceRangeStart(fieldInfo.declarationStart);
        info.setFlags(fieldInfo.modifiers);
        parentInfo.addChild(handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public boolean enterFieldCheckDuplicates(ISourceElementRequestor.FieldInfo fieldInfo, ModelElementInfo parentInfo, ModelElement parentHandle) {
        IModelElement[] childrens = parentInfo.getChildren();
        int i = 0;
        while (i < childrens.length) {
            if (childrens[i] instanceof SourceField && childrens[i].getElementName().equals(fieldInfo.name)) {
                SourceField handle = (SourceField)childrens[i];
                SourceFieldElementInfo info = (SourceFieldElementInfo)this.newElements.get(handle);
                this.infoStack.push(info);
                this.handleStack.push(handle);
                return true;
            }
            ++i;
        }
        if (parentInfo instanceof SourceMethodElementInfo) {
            SourceMethodElementInfo method = (SourceMethodElementInfo)parentInfo;
            String[] args = method.getArgumentNames();
            int i2 = 0;
            while (i2 < args.length) {
                if (args[i2].equals(fieldInfo.name)) {
                    return false;
                }
                ++i2;
            }
        }
        this.createField(fieldInfo, parentInfo, parentHandle);
        return true;
    }

    public boolean enterFieldCheckDuplicates(ISourceElementRequestor.FieldInfo fieldInfo) {
        ModelElementInfo parentInfo = (ModelElementInfo)this.infoStack.peek();
        ModelElement parentHandle = (ModelElement)this.handleStack.peek();
        return this.enterFieldCheckDuplicates(fieldInfo, parentInfo, parentHandle);
    }

    public void enterMethodRemoveSame(ISourceElementRequestor.MethodInfo methodInfo) {
        ModelElementInfo parentInfo = (ModelElementInfo)this.infoStack.peek();
        IModelElement[] childrens = parentInfo.getChildren();
        int i = 0;
        while (i < childrens.length) {
            if (childrens[i].getElementName().equals(methodInfo.name)) {
                parentInfo.removeChild(childrens[i]);
            }
            ++i;
        }
        this.enterMethod(methodInfo);
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        ModelElementInfo parentInfo = (ModelElementInfo)this.infoStack.peek();
        ModelElement parentHandle = (ModelElement)this.handleStack.peek();
        this.processMethod(methodInfo, parentInfo, parentHandle);
    }

    private void processMethod(ISourceElementRequestor.MethodInfo methodInfo, ModelElementInfo parentInfo, ModelElement parentHandle) {
        String[] parameterInitializers;
        String nameString = methodInfo.name;
        ModelManager manager = ModelManager.getModelManager();
        SourceMethod handle = new SourceMethod(parentHandle, manager.intern(nameString));
        this.resolveDuplicates(handle);
        SourceMethodElementInfo info = new SourceMethodElementInfo();
        info.setSourceRangeStart(methodInfo.declarationStart);
        info.setFlags(methodInfo.modifiers);
        info.setNameSourceStart(methodInfo.nameSourceStart);
        info.setNameSourceEnd(methodInfo.nameSourceEnd);
        info.setIsConstructor(methodInfo.isConstructor);
        String[] parameterNames = methodInfo.parameterNames == null ? EMPTY : methodInfo.parameterNames;
        String[] stringArray = parameterInitializers = methodInfo.parameterInitializers == null ? EMPTY : methodInfo.parameterInitializers;
        if (parameterNames.length != parameterInitializers.length) {
            parameterInitializers = new String[parameterNames.length];
        }
        int i = 0;
        int length = parameterNames.length;
        while (i < length) {
            parameterNames[i] = manager.intern(parameterNames[i]);
            if (parameterInitializers[i] != null) {
                parameterInitializers[i] = manager.intern(parameterInitializers[i]);
            }
            ++i;
        }
        info.setArgumentNames(parameterNames);
        info.setArgumentInializers(parameterInitializers);
        parentInfo.addChild(handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    private SourceType getCurrentType() {
        SourceType t = null;
        Iterator iter = this.handleStack.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof SourceType)) continue;
            t = (SourceType)o;
        }
        return t;
    }

    private SourceType getExistentType(String parentName, String delimiter) {
        try {
            SourceType element = null;
            if (parentName.startsWith(delimiter)) {
                element = this.findTypeFrom(this.module.getChildren(), "", parentName, delimiter);
                return element;
            }
            parentName = String.valueOf(delimiter) + parentName;
            SourceType enc = this.getCurrentType();
            element = enc == null ? this.findTypeFrom(this.module.getChildren(), "", parentName, delimiter) : this.findTypeFrom(enc.getChildren(), "", parentName, delimiter);
            return element;
        }
        catch (ModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    private SourceType findTypeFrom(IModelElement[] childs, String name, String parentName, String delimiter) {
        try {
            int i = 0;
            while (i < childs.length) {
                if (childs[i] instanceof SourceType) {
                    SourceType type = (SourceType)childs[i];
                    String qname = String.valueOf(name) + delimiter + type.getElementName();
                    if (qname.equals(parentName)) {
                        return type;
                    }
                    SourceType val = this.findTypeFrom(type.getChildren(), qname, parentName, delimiter);
                    if (val != null) {
                        return val;
                    }
                }
                ++i;
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean enterMethodWithParentType(ISourceElementRequestor.MethodInfo info, String parentName, String delimiter) {
        SourceType element;
        block5: {
            element = this.getExistentType(parentName, delimiter);
            if (element != null) break block5;
            return false;
        }
        try {
            ModelElementInfo typeInfo = (ModelElementInfo)element.getElementInfo();
            IModelElement[] childrens = typeInfo.getChildren();
            int i = 0;
            while (i < childrens.length) {
                if (childrens[i].getElementName().equals(info.name)) {
                    typeInfo.removeChild(childrens[i]);
                }
                ++i;
            }
            this.processMethod(info, typeInfo, element);
            return true;
        }
        catch (ModelException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean enterFieldWithParentType(ISourceElementRequestor.FieldInfo info, String parentName, String delimiter) {
        SourceType element;
        block4: {
            try {
                element = this.getExistentType(parentName, delimiter);
                if (element != null) break block4;
                return false;
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        ModelElementInfo typeInfo = (ModelElementInfo)element.getElementInfo();
        this.enterFieldCheckDuplicates(info, typeInfo, element);
        return true;
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        ModelElementInfo parentInfo = (ModelElementInfo)this.infoStack.peek();
        ModelElement parentHandle = (ModelElement)this.handleStack.peek();
        this.processType(typeInfo, parentInfo, parentHandle);
    }

    public boolean enterTypeAppend(String fullName, String delimiter) {
        SourceType element;
        block3: {
            try {
                element = this.getExistentType(fullName, delimiter);
                if (element != null) break block3;
                return false;
            }
            catch (ModelException e) {
                e.printStackTrace();
                return false;
            }
        }
        ModelElementInfo info = (ModelElementInfo)element.getElementInfo();
        this.infoStack.push(info);
        this.handleStack.push(element);
        return true;
    }

    private void processType(ISourceElementRequestor.TypeInfo typeInfo, ModelElementInfo parentInfo, ModelElement parentHandle) {
        String nameString = typeInfo.name;
        SourceType handle = new SourceType(parentHandle, nameString);
        this.resolveDuplicates(handle);
        SourceTypeElementInfo info = new SourceTypeElementInfo();
        info.setHandle(handle);
        info.setSourceRangeStart(typeInfo.declarationStart);
        info.setFlags(typeInfo.modifiers);
        info.setNameSourceStart(typeInfo.nameSourceStart);
        info.setNameSourceEnd(typeInfo.nameSourceEnd);
        ModelManager manager = ModelManager.getModelManager();
        String[] superclasses = typeInfo.superclasses;
        int i = 0;
        int length = superclasses == null ? 0 : superclasses.length;
        while (i < length) {
            superclasses[i] = manager.intern(superclasses[i]);
            ++i;
        }
        info.setSuperclassNames(superclasses);
        parentInfo.addChild(handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void exitModule(int declarationEnd) {
        this.moduleInfo.setSourceLength(declarationEnd + 1);
        this.moduleInfo.setIsStructureKnown(!this.hasSyntaxErrors);
    }

    public void exitModuleRoot() {
        this.infoStack.pop();
        this.handleStack.pop();
    }

    public void exitField(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitMethod(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitType(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void exitMember(int declarationEnd) {
        Object object = this.infoStack.pop();
        SourceRefElementInfo info = (SourceRefElementInfo)object;
        info.setSourceRangeEnd(declarationEnd);
        this.handleStack.pop();
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
        ModelElementInfo parentInfo = (ModelElementInfo)this.infoStack.peek();
        ModelElement parentHandle = (ModelElement)this.handleStack.peek();
        PackageDeclaration handle = null;
        handle = new PackageDeclaration(parentHandle, new String(name));
        this.resolveDuplicates(handle);
        SourceRefElementInfo info = new SourceRefElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        parentInfo.addChild(handle);
        this.newElements.put(handle, info);
    }

    public void acceptFieldReference(char[] fieldName, int sourcePosition) {
    }

    public void acceptMethodReference(char[] methodName, int argCount, int sourcePosition, int sourceEndPosition) {
    }

    public void acceptTypeReference(char[][] typeName, int sourceStart, int sourceEnd) {
    }

    public void acceptTypeReference(char[] typeName, int sourcePosition) {
    }
}

