/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.packets;

import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.dltk.dbgp.internal.DbgpRawPacket;
import org.eclipse.dltk.dbgp.internal.DbgpWorkingThread;
import org.eclipse.dltk.dbgp.internal.packets.DbgpNotifyPacket;
import org.eclipse.dltk.dbgp.internal.packets.DbgpPacket;
import org.eclipse.dltk.dbgp.internal.packets.DbgpResponsePacket;
import org.eclipse.dltk.dbgp.internal.packets.DbgpStreamPacket;
import org.eclipse.dltk.dbgp.internal.packets.IDbgpRawLogger;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlPacketParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DbgpPacketReceiver
extends DbgpWorkingThread {
    private static final String INIT_TAG = "init";
    private static final String RESPONSE_TAG = "response";
    private static final String STREAM_TAG = "stream";
    private static final String NOTIFY_TAG = "notify";
    private final ResponcePacketWaiter responseWaiter;
    private final PacketWaiter notifyWaiter;
    private final PacketWaiter streamWaiter;
    private final InputStream input;
    private IDbgpRawLogger logger;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void workingCycle() throws Exception {
        try {
            while (!Thread.interrupted()) {
                DbgpRawPacket packet = DbgpRawPacket.readPacket(this.input);
                if (this.logger != null) {
                    this.logger.log(packet.getXml());
                }
                this.addDocument(packet.getParsedXml());
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.responseWaiter.terminate();
            this.notifyWaiter.terminate();
            this.streamWaiter.terminate();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.responseWaiter.terminate();
            this.notifyWaiter.terminate();
            this.streamWaiter.terminate();
            return;
        }
    }

    protected void addDocument(Document doc) {
        Element element = (Element)doc.getFirstChild();
        String tag = element.getTagName();
        if (tag.equals(INIT_TAG)) {
            this.responseWaiter.put(new DbgpResponsePacket(element, -1));
        } else if (tag.equals(RESPONSE_TAG)) {
            DbgpResponsePacket packet = DbgpXmlPacketParser.parseResponsePacket(element);
            this.responseWaiter.put(packet);
        } else if (tag.equals(STREAM_TAG)) {
            this.streamWaiter.put(DbgpXmlPacketParser.parseStreamPacket(element));
        } else if (tag.equals(NOTIFY_TAG)) {
            this.notifyWaiter.put(DbgpXmlPacketParser.parseNotifyPacket(element));
        }
    }

    public DbgpNotifyPacket getNotifyPacket() throws InterruptedException {
        return (DbgpNotifyPacket)this.notifyWaiter.waitPacket();
    }

    public DbgpStreamPacket getStreamPacket() throws InterruptedException {
        return (DbgpStreamPacket)this.streamWaiter.waitPacket();
    }

    public DbgpResponsePacket getResponsePacket(int transactionId, int timeout) throws InterruptedException {
        return this.responseWaiter.waitPacket(transactionId, timeout);
    }

    public DbgpPacketReceiver(InputStream input) {
        super("DBGP - Packet receiver");
        if (input == null) {
            throw new IllegalArgumentException();
        }
        this.input = input;
        this.notifyWaiter = new PacketWaiter();
        this.streamWaiter = new PacketWaiter();
        this.responseWaiter = new ResponcePacketWaiter();
    }

    public void setLogger(IDbgpRawLogger logger) {
        this.logger = logger;
    }

    private static class PacketWaiter {
        private final LinkedList queue = new LinkedList();
        private boolean terminated = false;

        public synchronized void put(DbgpPacket obj) {
            this.queue.addLast(obj);
            this.notifyAll();
        }

        public synchronized DbgpPacket waitPacket() throws InterruptedException {
            while (!this.terminated && this.queue.isEmpty()) {
                this.wait();
            }
            if (this.terminated) {
                throw new InterruptedException();
            }
            return (DbgpPacket)this.queue.removeFirst();
        }

        public synchronized void terminate() {
            this.terminated = true;
            this.notifyAll();
        }
    }

    private static class ResponcePacketWaiter {
        private static final int MIN_TIMEOUT = 5;
        private final HashMap map = new HashMap();
        private boolean terminated = false;

        public synchronized void put(DbgpResponsePacket packet) {
            int id = packet.getTransactionId();
            this.map.put(new Integer(id), packet);
            this.notifyAll();
        }

        public synchronized DbgpResponsePacket waitPacket(int id, int timeout) throws InterruptedException {
            Integer key = new Integer(id);
            while (!this.terminated && !this.map.containsKey(key)) {
                if (timeout != 0 && timeout < 5) break;
                long begin = System.currentTimeMillis();
                this.wait(timeout);
                long delta = System.currentTimeMillis() - begin;
                if (timeout == 0) continue;
                timeout = (int)((long)timeout - delta);
            }
            if (this.map.containsKey(key)) {
                return (DbgpResponsePacket)this.map.remove(key);
            }
            if (this.terminated) {
                throw new InterruptedException();
            }
            return null;
        }

        public synchronized void terminate() {
            this.terminated = true;
            this.notifyAll();
        }
    }
}

