/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.internal.debug.core.model.StrUtils;

public abstract class AbstractScriptBreakpoint
extends Breakpoint
implements IScriptBreakpoint {
    public static final String ENGINE_IDENTIFIER = "org.eclipse.dltk.debug.id";
    public static final String HIT_COUNT = "org.eclipse.dltk.debug.hit_count";
    public static final String EXPRESSION = "org.eclipse.dltk.debug.expression";
    public static final String EXPRESSION_STATE = "org.eclipse.dltk.debug.expression.state";
    public static final String HIT_VALUE = "org.eclipse.dltk.debug.hit_value";
    public static final String HIT_CONDITION = "org.eclipse.dltk.debug.hit_condition";

    public static URI makeUri(IPath location) {
        try {
            String path = EnvironmentPathUtils.getLocalPath((IPath)location).toString();
            if (path.length() != 0 && path.charAt(0) != '/') {
                path = String.valueOf('/') + path;
            }
            return new URI("file", "", path, null);
        }
        catch (URISyntaxException e) {
            DLTKDebugPlugin.log(e);
            return null;
        }
    }

    protected void addScriptBreakpointAttributes(Map attributes, String debugModelId, boolean enabled) {
        attributes.put("org.eclipse.debug.core.id", debugModelId);
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
    }

    public String getModelIdentifier() {
        try {
            return this.ensureMarker().getAttribute("org.eclipse.debug.core.id", null);
        }
        catch (DebugException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public String getIdentifier() throws CoreException {
        return this.ensureMarker().getAttribute(ENGINE_IDENTIFIER, null);
    }

    public void setIdentifier(String id) throws CoreException {
        this.setAttribute(ENGINE_IDENTIFIER, id);
    }

    public String getMessage() throws CoreException {
        return this.ensureMarker().getAttribute("message", null);
    }

    public void setMessage(String message) throws CoreException {
        this.setAttribute("message", message);
    }

    public int getHitCount() throws CoreException {
        return this.ensureMarker().getAttribute(HIT_COUNT, -1);
    }

    public void setHitCount(int value) throws CoreException {
        this.setAttribute(HIT_COUNT, value);
    }

    public int getHitValue() throws CoreException {
        return this.ensureMarker().getAttribute(HIT_VALUE, -1);
    }

    public void setHitValue(int hitValue) throws CoreException {
        if (this.getHitValue() != hitValue) {
            this.setAttribute(HIT_VALUE, hitValue);
        }
    }

    public int getHitCondition() throws CoreException {
        return this.ensureMarker().getAttribute(HIT_CONDITION, -1);
    }

    public void setHitCondition(int condition) throws CoreException {
        if (this.getHitCondition() != condition) {
            this.setAttribute(HIT_CONDITION, condition);
        }
    }

    public String getResourceName() throws CoreException {
        return this.ensureMarker().getResource().getName();
    }

    public String getExpression() throws CoreException {
        return this.ensureMarker().getAttribute(EXPRESSION, null);
    }

    public void setExpression(String expression) throws CoreException {
        if (!StrUtils.equals(this.getExpression(), expression)) {
            this.setAttribute(EXPRESSION, expression);
        }
    }

    public boolean getExpressionState() throws CoreException {
        return this.ensureMarker().getAttribute(EXPRESSION_STATE, false);
    }

    public void setExpressionState(boolean state) throws CoreException {
        if (this.getExpressionState() != state) {
            this.setAttribute(EXPRESSION_STATE, state);
        }
    }

    public void register(boolean register) throws CoreException {
        DebugPlugin plugin = DebugPlugin.getDefault();
        if (plugin != null && register) {
            plugin.getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }
}

