/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.breakpoints;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.ScriptDebugManager;
import org.eclipse.dltk.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptMethodEntryBreakpoint;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.core.model.AbstractScriptBreakpoint;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugModel;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class BreakpointUtils {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static String getNatureId(IScriptBreakpoint breakpoint) {
        ScriptDebugManager manager = ScriptDebugManager.getInstance();
        return manager.getNatureByDebugModel(breakpoint.getModelIdentifier());
    }

    public static IDLTKLanguageToolkit getLanguageToolkit(IScriptBreakpoint breakpoint) {
        return DLTKLanguageManager.getLanguageToolkit((String)BreakpointUtils.getNatureId(breakpoint));
    }

    public static IDLTKUILanguageToolkit getUILanguageToolkit(IScriptBreakpoint breakpoint) {
        return DLTKUILanguageManager.getLanguageToolkit((String)BreakpointUtils.getNatureId(breakpoint));
    }

    public static void addLineBreakpoint(ITextEditor textEditor, int lineNumber) throws CoreException {
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IResource resource = BreakpointUtils.getBreakpointResource(textEditor);
        try {
            IRegion line = document.getLineInformation(lineNumber - 1);
            int start = line.getOffset();
            int end = start + line.getLength();
            String debugModelId = BreakpointUtils.getDebugModelId(textEditor, resource);
            if (debugModelId == null) {
                return;
            }
            IPath location = BreakpointUtils.getBreakpointResourceLocation(textEditor);
            ScriptDebugModel.createLineBreakpoint((String)debugModelId, (IResource)resource, (IPath)location, (int)lineNumber, (int)start, (int)end, (boolean)true, null);
        }
        catch (BadLocationException e) {
            DLTKDebugPlugin.log((Throwable)e);
        }
    }

    public static IResource getBreakpointResource(ITextEditor textEditor) {
        IResource resource;
        IEditorInput iEditorInput = textEditor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)iEditorInput.getAdapter((Class)clazz)) == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    public static IPath getBreakpointResourceLocation(ITextEditor textEditor) throws CoreException {
        IModelElement element;
        IResource resource;
        IEditorInput iEditorInput = textEditor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)iEditorInput.getAdapter((Class)clazz)) != null) {
            return new Path(resource.getLocationURI().getPath());
        }
        IEditorInput iEditorInput2 = textEditor.getEditorInput();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.dltk.core.IModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((element = (IModelElement)iEditorInput2.getAdapter((Class)clazz2)) != null) {
            return element.getPath();
        }
        return null;
    }

    private static String getDebugModelId(ITextEditor textEditor, IResource resource) throws CoreException {
        IDLTKLanguageToolkit toolkit;
        IModelElement element;
        String debugModelId = ScriptDebugModel.getDebugModelId((IResource)resource);
        if (debugModelId != null) {
            return debugModelId;
        }
        IEditorInput iEditorInput = textEditor.getEditorInput();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.dltk.core.IModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((element = (IModelElement)iEditorInput.getAdapter((Class)clazz)) != null && (toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)element)) != null) {
            return ScriptDebugManager.getInstance().getDebugModelByNature(toolkit.getNatureId());
        }
        return null;
    }

    public static ILineBreakpoint findLineBreakpoint(ITextEditor editor, int lineNumber) throws CoreException {
        IResource resource = BreakpointUtils.getBreakpointResource(editor);
        String debugModelId = BreakpointUtils.getDebugModelId(editor, resource);
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(debugModelId);
        IPath breakPointResourceLocation = BreakpointUtils.getBreakpointResourceLocation(editor);
        if (breakPointResourceLocation == null) {
            return null;
        }
        String location = breakPointResourceLocation.toPortableString();
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            IResource bpResource = breakpoint.getMarker().getResource();
            String bpLocation = (String)breakpoint.getMarker().getAttribute("location");
            if (resource.equals((Object)bpResource) && location.equals(bpLocation)) {
                ILineBreakpoint lineBreakpoint = (ILineBreakpoint)breakpoint;
                try {
                    if (lineBreakpoint.getLineNumber() == lineNumber) {
                        return lineBreakpoint;
                    }
                }
                catch (CoreException e) {
                    DLTKDebugUIPlugin.log(e);
                }
            }
            ++i;
        }
        return null;
    }

    public static void addMethodEntryBreakpoint(ITextEditor textEditor, int lineNumber, String methodName) throws CoreException {
        IResource resource;
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IEditorInput iEditorInput = textEditor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)iEditorInput.getAdapter((Class)clazz)) != null) {
            try {
                IRegion line = document.getLineInformation(lineNumber - 1);
                int start = line.getOffset();
                int end = start + line.getLength() - 1;
                IPath path = resource.getLocation();
                IScriptMethodEntryBreakpoint methodEntryBreakpoint = ScriptDebugModel.createMethodEntryBreakpoint((IResource)resource, (IPath)path, (int)lineNumber, (int)start, (int)end, (boolean)false, null, (String)methodName);
                methodEntryBreakpoint.setBreakOnEntry(true);
                ((AbstractScriptBreakpoint)methodEntryBreakpoint).register(true);
            }
            catch (BadLocationException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
    }

    public static void addWatchPoint(ITextEditor textEditor, int lineNumber, String fieldName) throws CoreException {
        IResource resource;
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IEditorInput iEditorInput = textEditor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)iEditorInput.getAdapter((Class)clazz)) != null) {
            try {
                IRegion line = document.getLineInformation(lineNumber - 1);
                int start = line.getOffset();
                int end = start + line.getLength() - 1;
                IPath path = resource.getLocation();
                ScriptDebugModel.createWatchPoint((IResource)resource, (IPath)path, (int)lineNumber, (int)start, (int)end, (String)fieldName);
            }
            catch (BadLocationException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
    }

    public static void addExceptionBreakpoint(String debugModelId, boolean caught, boolean uncaught, IType type) throws CoreException {
        IResource resource = type.getResource();
        if (resource == null || !resource.getProject().exists()) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        if (resource != null) {
            ScriptDebugModel.createExceptionBreakpoint((String)debugModelId, (IResource)resource, (String)type.getFullyQualifiedName(), (boolean)caught, (boolean)uncaught, (boolean)true, null);
        }
    }
}

