/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.util.SimpleLookupTable;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.search.BasicSearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.index.MixinIndex;
import org.eclipse.dltk.core.search.indexing.AddBuiltinFolderToIndex;
import org.eclipse.dltk.core.search.indexing.AddExternalFolderToIndex;
import org.eclipse.dltk.core.search.indexing.AddFolderToIndex;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.core.search.indexing.IndexAllProject;
import org.eclipse.dltk.core.search.indexing.IndexRequest;
import org.eclipse.dltk.core.search.indexing.ReadWriteMonitor;
import org.eclipse.dltk.core.search.indexing.RemoveFolderFromIndex;
import org.eclipse.dltk.core.search.indexing.RemoveFromIndex;
import org.eclipse.dltk.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.search.PatternSearchJob;
import org.eclipse.dltk.internal.core.search.processing.IJob;
import org.eclipse.dltk.internal.core.search.processing.JobManager;
import org.eclipse.dltk.internal.core.util.Messages;

public class IndexManager
extends JobManager
implements IIndexConstants {
    public SimpleLookupTable indexLocations = new SimpleLookupTable();
    private Map indexes = new HashMap(5);
    private boolean needToSave = false;
    private static final CRC32 checksumCalculator = new CRC32();
    private IPath javaPluginLocation = null;
    private SimpleLookupTable indexStates = null;
    private File savedIndexNamesFile = new File(this.getScriptPluginWorkingLocation().append("savedIndexNames.txt").toOSString());
    public static Integer SAVED_STATE = new Integer(0);
    public static Integer UPDATING_STATE = new Integer(1);
    public static Integer UNKNOWN_STATE = new Integer(2);
    public static Integer REBUILDING_STATE = new Integer(3);
    public static List sourcesToMixin = new ArrayList();

    public synchronized void aboutToUpdateIndex(IPath containerPath, Integer newIndexState) {
        Integer currentIndexState;
        String indexLocation = this.computeIndexLocation(containerPath);
        Object state = this.getIndexStates().get(indexLocation);
        Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
        if (currentIndexState.equals(REBUILDING_STATE)) {
            return;
        }
        int compare = newIndexState.compareTo(currentIndexState);
        if (compare > 0) {
            this.updateIndexState(indexLocation, newIndexState);
        } else if (compare < 0 && this.indexes.get(indexLocation) == null) {
            this.rebuildIndex(indexLocation, containerPath);
        }
    }

    public void addSource(IFile resource, IPath containerPath, ISourceElementParser parser, SourceIndexerRequestor requestor, IDLTKLanguageToolkit toolkit) {
        if (DLTKCore.getPlugin() == null) {
            return;
        }
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        SearchDocument document = participant.getDocument(resource.getFullPath().toString(), resource.getProject());
        document.parser = parser;
        document.requestor = requestor;
        document.toolkit = toolkit;
        document.fullPath = resource.getFullPath();
        String indexLocation = this.computeIndexLocation(containerPath);
        this.scheduleDocumentIndexing(document, containerPath, indexLocation, participant);
    }

    public void addBinary(IFile resource, IPath containerPath) {
        if (DLTKCore.getPlugin() == null) {
            return;
        }
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        SearchDocument document = participant.getDocument(resource.getFullPath().toString(), resource.getProject());
        String indexLocation = this.computeIndexLocation(containerPath);
        this.scheduleDocumentIndexing(document, containerPath, indexLocation, participant);
    }

    public void cleanUpIndexes() {
        File[] indexesFiles;
        File indexesDirectory;
        SimpleLookupTable knownPaths = new SimpleLookupTable();
        IDLTKSearchScope scope = BasicSearchEngine.createWorkspaceScope(null);
        PatternSearchJob job = new PatternSearchJob(null, SearchEngine.getDefaultSearchParticipant(), scope, null);
        Index[] selectedIndexes = job.getIndexes(null);
        int j = 0;
        int max = selectedIndexes.length;
        while (j < max) {
            String path = selectedIndexes[j].getIndexFile().getAbsolutePath();
            knownPaths.put(path, path);
            ++j;
        }
        if (this.indexStates != null) {
            Object[] keys = this.indexStates.keyTable;
            int keysLength = keys.length;
            int updates = 0;
            String[] locations = new String[keysLength];
            int i = 0;
            int l = keys.length;
            while (i < l) {
                String key = (String)keys[i];
                if (key != null && !knownPaths.containsKey(key)) {
                    locations[updates++] = key;
                }
                ++i;
            }
            if (updates > 0) {
                this.removeIndexesState(locations);
            }
        }
        if ((indexesDirectory = new File(this.getScriptPluginWorkingLocation().toOSString())).isDirectory() && (indexesFiles = indexesDirectory.listFiles()) != null) {
            int i = 0;
            int indexesFilesLength = indexesFiles.length;
            while (i < indexesFilesLength) {
                String fileName = indexesFiles[i].getAbsolutePath();
                if (!knownPaths.containsKey(fileName) && fileName.toLowerCase().endsWith(".index")) {
                    indexesFiles[i].delete();
                }
                ++i;
            }
        }
    }

    public synchronized String computeIndexLocation(IPath containerPath) {
        String indexLocation = (String)this.indexLocations.get(containerPath);
        if (indexLocation == null) {
            String pathString = containerPath.toString();
            checksumCalculator.reset();
            checksumCalculator.update(pathString.getBytes());
            String fileName = String.valueOf(Long.toString(checksumCalculator.getValue())) + ".index";
            indexLocation = this.getScriptPluginWorkingLocation().append(fileName).toOSString();
            this.indexLocations.put(containerPath, indexLocation);
        }
        return indexLocation;
    }

    public void ensureIndexExists(String indexLocation, IPath containerPath) {
        SimpleLookupTable states = this.getIndexStates();
        Object state = states.get(indexLocation);
        if (state == null) {
            this.updateIndexState(indexLocation, REBUILDING_STATE);
            this.getIndex(containerPath, indexLocation, true, true);
        }
    }

    public SourceIndexerRequestor getSourceRequestor(IScriptProject scriptProject) {
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit(scriptProject);
        if (toolkit != null) {
            return DLTKLanguageManager.createSourceRequestor(toolkit.getNatureId());
        }
        return null;
    }

    public ISourceElementParser getSourceElementParser(IScriptProject project, ISourceElementRequestor requestor) {
        ISourceElementParser parser = this.getSourceElementParser(project);
        if (parser != null) {
            parser.setRequestor(requestor);
        }
        return parser;
    }

    public ISourceElementParser getSourceElementParser(IScriptProject project) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(project);
        if (toolkit != null) {
            return DLTKLanguageManager.getSourceElementParser(toolkit.getNatureId());
        }
        return null;
    }

    public synchronized Index getIndex(IPath containerPath, boolean reuseExistingFile, boolean createIfMissing) {
        String indexLocation = this.computeIndexLocation(containerPath);
        return this.getIndex(containerPath, indexLocation, reuseExistingFile, createIfMissing);
    }

    public synchronized Index getSpecialIndex(String id, String path, String containerPath) {
        boolean mixin = id.equals("mixin");
        String indexLocation = this.computeIndexLocation((IPath)new Path("#special#" + id + "#" + path));
        Index index = (Index)this.indexes.get(indexLocation);
        if (index == null) {
            Object state = this.getIndexStates().get(indexLocation);
            Integer currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
            File indexFile = new File(indexLocation);
            if (indexFile.exists()) {
                try {
                    index = mixin ? new MixinIndex(indexLocation, containerPath, true) : new Index(indexLocation, containerPath, true);
                    this.indexes.put(indexLocation, index);
                    return index;
                }
                catch (IOException iOException) {
                    if (currentIndexState != REBUILDING_STATE) {
                        // empty if block
                    }
                }
            }
            try {
                index = mixin ? new MixinIndex(indexLocation, containerPath, false) : new Index(indexLocation, containerPath, false);
                this.indexes.put(indexLocation, index);
                return index;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        this.updateIndexState(indexLocation, REBUILDING_STATE);
        return index;
    }

    public synchronized Index getIndex(IPath containerPath, String indexLocation, boolean reuseExistingFile, boolean createIfMissing) {
        boolean mixin = containerPath.toString().startsWith("#special#mixin#");
        Index index = (Index)this.indexes.get(indexLocation);
        if (index == null) {
            Integer currentIndexState;
            Object state = this.getIndexStates().get(indexLocation);
            Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
            if (currentIndexState.equals(UNKNOWN_STATE)) {
                this.rebuildIndex(indexLocation, containerPath);
                if (!mixin) {
                    return null;
                }
            }
            String containerPathString = containerPath.toString();
            if (reuseExistingFile) {
                block11: {
                    File indexFile = new File(indexLocation);
                    if (indexFile.exists()) {
                        try {
                            index = mixin ? new MixinIndex(indexLocation, containerPathString, true) : new Index(indexLocation, containerPathString, true);
                            this.indexes.put(indexLocation, index);
                            return index;
                        }
                        catch (IOException iOException) {
                            if (currentIndexState == REBUILDING_STATE) break block11;
                            this.rebuildIndex(indexLocation, containerPath);
                            return null;
                        }
                    }
                }
                if (currentIndexState == SAVED_STATE) {
                    this.rebuildIndex(indexLocation, containerPath);
                    return null;
                }
            }
            if (createIfMissing) {
                try {
                    index = mixin ? new MixinIndex(indexLocation, containerPathString, false) : new Index(indexLocation, containerPathString, false);
                    this.indexes.put(indexLocation, index);
                    return index;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        }
        return index;
    }

    public synchronized Index getIndex(String indexLocation) {
        return (Index)this.indexes.get(indexLocation);
    }

    public synchronized Index getIndexForUpdate(IPath containerPath, boolean reuseExistingFile, boolean createIfMissing) {
        String indexLocation = this.computeIndexLocation(containerPath);
        if (this.getIndexStates().get(indexLocation) == REBUILDING_STATE) {
            return this.getIndex(containerPath, indexLocation, reuseExistingFile, createIfMissing);
        }
        return null;
    }

    private SimpleLookupTable getIndexStates() {
        block5: {
            File indexesDirectory;
            block6: {
                char[][] names;
                if (this.indexStates != null) {
                    return this.indexStates;
                }
                this.indexStates = new SimpleLookupTable();
                char[] savedIndexNames = this.readIndexState();
                if (savedIndexNames.length <= 0 || (names = CharOperation.splitOn('\n', savedIndexNames)).length <= 0) break block5;
                indexesDirectory = new File(this.getScriptPluginWorkingLocation().toOSString());
                char[] dirName = indexesDirectory.getAbsolutePath().toCharArray();
                int delimiterPos = dirName.length;
                if (!CharOperation.match(names[0], 0, delimiterPos, dirName, 0, delimiterPos, true)) break block6;
                int i = 0;
                int l = names.length;
                while (i < l) {
                    char[] name = names[i];
                    if (name.length > 0) {
                        this.indexStates.put(new String(name), SAVED_STATE);
                    }
                    ++i;
                }
                break block5;
            }
            this.savedIndexNamesFile.delete();
            File[] files = indexesDirectory.listFiles();
            if (files == null) break block5;
            int i = 0;
            int l = files.length;
            while (i < l) {
                String fileName = files[i].getAbsolutePath();
                if (fileName.toLowerCase().endsWith(".index")) {
                    files[i].delete();
                }
                ++i;
            }
        }
        return this.indexStates;
    }

    private IPath getScriptPluginWorkingLocation() {
        IPath stateLocation;
        if (this.javaPluginLocation != null) {
            return this.javaPluginLocation;
        }
        this.javaPluginLocation = stateLocation = DLTKCore.getPlugin().getStateLocation();
        return this.javaPluginLocation;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void indexDocument(SearchDocument searchDocument, SearchParticipant searchParticipant, Index index, IPath indexLocation) {
        try {
            searchDocument.index = index;
            searchParticipant.indexDocument(searchDocument, indexLocation);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            searchDocument.index = null;
            throw throwable;
        }
        {
            Object var5_7 = null;
            searchDocument.index = null;
            return;
        }
    }

    public void indexAll(IProject project) {
        if (DLTKCore.getPlugin() == null) {
            return;
        }
        try {
            Model model = ModelManager.getModelManager().getModel();
            ScriptProject scriptProject = (ScriptProject)model.getScriptProject((IResource)project);
            IBuildpathEntry[] entries = scriptProject.getResolvedBuildpath(true, false, false);
            int i = 0;
            while (i < entries.length) {
                IBuildpathEntry entry = entries[i];
                if (entry.getEntryKind() == 1) {
                    this.indexLibrary(entry.getPath(), project, ((BuildpathEntry)entry).fullInclusionPatternChars(), ((BuildpathEntry)entry).fullExclusionPatternChars());
                }
                ++i;
            }
        }
        catch (ModelException modelException) {}
        IndexAllProject request = new IndexAllProject(project, this);
        if (!this.isJobWaiting(request)) {
            this.request(request);
        }
    }

    public void indexLibrary(IPath path, IProject requestingProject, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        if (DLTKCore.getPlugin() == null) {
            return;
        }
        Object target = Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), path, true);
        IndexRequest request = null;
        if (target instanceof IFile) {
            return;
        }
        if (target instanceof IFileHandle) {
            if (((IFileHandle)target).isFile()) {
                return;
            }
            request = new AddExternalFolderToIndex(path, requestingProject, inclusionPatterns, exclusionPatterns, this);
        } else {
            if (target instanceof IContainer) {
                return;
            }
            if (target == null && path.toString().startsWith("#special#builtin#")) {
                request = new AddBuiltinFolderToIndex(path, requestingProject, this);
            }
        }
        if (request != null && !this.isJobWaiting(request)) {
            this.request(request);
        }
    }

    public void indexSourceFolder(ScriptProject scriptProject, IPath sourceFolder, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        IndexAllProject request;
        IProject project = scriptProject.getProject();
        if (this.jobEnd > this.jobStart && this.isJobWaiting(request = new IndexAllProject(project, this))) {
            return;
        }
        this.request(new AddFolderToIndex(sourceFolder, project, inclusionPatterns, exclusionPatterns, this));
    }

    public void jobWasCancelled(IPath containerPath) {
        String indexLocation = this.computeIndexLocation(containerPath);
        Object o = this.indexes.get(indexLocation);
        if (o instanceof Index) {
            ((Index)o).monitor = null;
            this.indexes.remove(indexLocation);
        }
        this.updateIndexState(indexLocation, UNKNOWN_STATE);
    }

    protected synchronized void moveToNextJob() {
        this.needToSave = true;
        super.moveToNextJob();
    }

    protected void notifyIdle(long idlingTime) {
        if (idlingTime > 1000L && this.needToSave) {
            this.saveIndexes();
        }
    }

    public String processName() {
        return Messages.process_name;
    }

    private void rebuildIndex(String indexLocation, IPath containerPath) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return;
        }
        Object target = Model.getTarget((IContainer)workspace.getRoot(), containerPath, true);
        if (target == null) {
            return;
        }
        this.updateIndexState(indexLocation, REBUILDING_STATE);
        IndexAllProject request = null;
        if (target instanceof IProject) {
            IProject p = (IProject)target;
            if (ScriptProject.hasScriptNature(p)) {
                request = new IndexAllProject(p, this);
            }
        } else {
            if (target instanceof IFolder) {
                return;
            }
            if (target instanceof IFile) {
                return;
            }
            if (target instanceof IFileHandle) {
                return;
            }
        }
        if (request != null) {
            this.request(request);
        }
    }

    public synchronized Index recreateIndex(IPath containerPath) {
        boolean mixin = containerPath.toString().startsWith("#special#mixin#");
        String containerPathString = containerPath.toString();
        try {
            String indexLocation = this.computeIndexLocation(containerPath);
            Index index = (Index)this.indexes.get(indexLocation);
            ReadWriteMonitor monitor = index == null ? null : index.monitor;
            index = mixin ? new MixinIndex(indexLocation, containerPathString, false) : new Index(indexLocation, containerPathString, false);
            this.indexes.put(indexLocation, index);
            index.monitor = monitor;
            return index;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void remove(String containerRelativePath, IPath indexedContainer) {
        this.request(new RemoveFromIndex(containerRelativePath, indexedContainer, this));
    }

    public synchronized void removeIndex(IPath containerPath) {
        Object o;
        String indexLocation = this.computeIndexLocation(containerPath);
        File indexFile = new File(indexLocation);
        if (indexFile.exists()) {
            indexFile.delete();
        }
        if ((o = this.indexes.remove(indexLocation)) instanceof Index) {
            Index index = (Index)o;
            index.monitor = null;
            if (index.isRebuildable()) {
                this.updateIndexState(indexLocation, null);
            }
        }
    }

    public synchronized void removeIndexPath(IPath path) {
        Set keySet = this.indexes.keySet();
        Iterator keys = keySet.iterator();
        String[] locations = null;
        int max = keySet.size();
        int ptr = 0;
        while (keys.hasNext()) {
            String indexLocation = (String)keys.next();
            Path indexPath = new Path(indexLocation);
            if (path.isPrefixOf((IPath)indexPath)) {
                Index index = (Index)this.indexes.get(indexLocation);
                if (index != null) {
                    index.monitor = null;
                }
                if (locations == null) {
                    locations = new String[max];
                }
                locations[ptr++] = indexLocation;
                File indexFile = new File(indexLocation);
                if (!indexFile.exists()) continue;
                indexFile.delete();
                continue;
            }
            if (locations != null) continue;
            --max;
        }
        if (locations != null) {
            int i = 0;
            while (i < ptr) {
                this.indexes.remove(locations[i]);
                ++i;
            }
            this.removeIndexesState(locations);
        }
    }

    public synchronized void removeIndexFamily(IPath path) {
        ArrayList<IPath> toRemove = null;
        Object[] containerPaths = this.indexLocations.keyTable;
        int i = 0;
        int length = containerPaths.length;
        while (i < length) {
            IPath containerPath = (IPath)containerPaths[i];
            if (containerPath != null && path.isPrefixOf(containerPath)) {
                if (toRemove == null) {
                    toRemove = new ArrayList<IPath>();
                }
                toRemove.add(containerPath);
            }
            ++i;
        }
        if (toRemove != null) {
            i = 0;
            length = toRemove.size();
            while (i < length) {
                this.removeIndex((IPath)toRemove.get(i));
                ++i;
            }
        }
    }

    public void removeSourceFolderFromIndex(ScriptProject scriptProject, IPath sourceFolder, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        IndexAllProject request;
        IProject project = scriptProject.getProject();
        if (this.jobEnd > this.jobStart && this.isJobWaiting(request = new IndexAllProject(project, this))) {
            return;
        }
        this.request(new RemoveFolderFromIndex(sourceFolder, inclusionPatterns, exclusionPatterns, project, this));
    }

    public synchronized void reset() {
        super.reset();
        if (this.indexes != null) {
            this.indexes = new HashMap(5);
            this.indexStates = null;
        }
        this.indexLocations = new SimpleLookupTable();
        this.javaPluginLocation = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveIndex(Index index) throws IOException {
        Object containerPath;
        if (index.hasChanged()) {
            index.save();
        }
        if (!index.isRebuildable()) {
            return;
        }
        String indexLocation = index.getIndexFile().getPath();
        if (this.jobEnd > this.jobStart && (containerPath = this.indexLocations.keyForValue(indexLocation)) != null) {
            IndexManager indexManager = this;
            synchronized (indexManager) {
                int i = this.jobEnd;
                while (i > this.jobStart) {
                    IJob job = this.awaitingJobs[i];
                    if (job instanceof IndexRequest && ((IndexRequest)job).containerPath.equals(containerPath)) {
                        return;
                    }
                    --i;
                }
            }
        }
        this.updateIndexState(indexLocation, SAVED_STATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveIndexes() {
        ArrayList toSave = new ArrayList();
        IndexManager indexManager = this;
        synchronized (indexManager) {
            Iterator iter = this.indexes.values().iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof Index)) continue;
                toSave.add(o);
            }
        }
        boolean allSaved = true;
        int i = 0;
        int length = toSave.size();
        while (i < length) {
            Index index = (Index)toSave.get(i);
            ReadWriteMonitor monitor = index.monitor;
            if (monitor != null) {
                Object var9_11;
                try {
                    monitor.enterRead();
                    if (index.hasChanged()) {
                        if (monitor.exitReadEnterWrite()) {
                            Object var7_10;
                            try {
                                try {
                                    this.saveIndex(index);
                                }
                                catch (IOException iOException) {
                                    allSaved = false;
                                }
                                var7_10 = null;
                                monitor.exitWriteEnterRead();
                            }
                            catch (Throwable throwable) {
                                var7_10 = null;
                                monitor.exitWriteEnterRead();
                                throw throwable;
                            }
                        } else {
                            allSaved = false;
                        }
                    }
                    var9_11 = null;
                    monitor.exitRead();
                }
                catch (Throwable throwable) {
                    var9_11 = null;
                    monitor.exitRead();
                    throw throwable;
                }
            }
            ++i;
        }
        this.needToSave = !allSaved;
    }

    public void scheduleDocumentIndexing(final SearchDocument searchDocument, IPath container, final String indexLocation, final SearchParticipant searchParticipant) {
        this.request(new IndexRequest(container, this){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean execute(IProgressMonitor progressMonitor) {
                if (this.isCancelled) return true;
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    return true;
                }
                Index index = IndexManager.this.getIndex(this.containerPath, indexLocation, true, true);
                if (index == null) {
                    return true;
                }
                ReadWriteMonitor monitor = index.monitor;
                if (monitor == null) {
                    return true;
                }
                try {
                    monitor.enterWrite();
                    IndexManager.this.indexDocument(searchDocument, searchParticipant, index, (IPath)new Path(indexLocation));
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    monitor.exitWrite();
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                    monitor.exitWrite();
                    return true;
                }
            }

            public String toString() {
                return "indexing " + searchDocument.getPath();
            }
        });
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append(super.toString());
        buffer.append("In-memory indexes:\n");
        int count = 0;
        Iterator iter = this.indexes.values().iterator();
        while (iter.hasNext()) {
            buffer.append(++count).append(" - ").append(iter.next().toString()).append('\n');
        }
        return buffer.toString();
    }

    private char[] readIndexState() {
        try {
            return Util.getFileCharContent(this.savedIndexNamesFile, null);
        }
        catch (IOException iOException) {
            return new char[0];
        }
    }

    private synchronized void removeIndexesState(String[] locations) {
        this.getIndexStates();
        int length = locations.length;
        boolean changed = false;
        int i = 0;
        while (i < length) {
            if (locations[i] != null && this.indexStates.removeKey(locations[i]) != null) {
                changed = true;
            }
            ++i;
        }
        if (!changed) {
            return;
        }
        this.writeSavedIndexNamesFile();
    }

    private synchronized void updateIndexState(String indexLocation, Integer indexState) {
        this.getIndexStates();
        if (indexState != null) {
            if (indexState.equals(this.indexStates.get(indexLocation))) {
                return;
            }
            this.indexStates.put(indexLocation, indexState);
        } else {
            if (!this.indexStates.containsKey(indexLocation)) {
                return;
            }
            this.indexStates.removeKey(indexLocation);
        }
        this.writeSavedIndexNamesFile();
    }

    /*
     * Exception decompiling
     */
    private void writeSavedIndexNamesFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 115->119)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void rebuild() {
        File[] indexesFiles;
        this.disable();
        File indexesDirectory = new File(this.getScriptPluginWorkingLocation().toOSString());
        if (indexesDirectory.isDirectory() && (indexesFiles = indexesDirectory.listFiles()) != null) {
            int i = 0;
            int indexesFilesLength = indexesFiles.length;
            while (i < indexesFilesLength) {
                indexesFiles[i].delete();
                ++i;
            }
        }
        this.reset();
        this.enable();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            if (DLTKLanguageManager.hasScriptNature(projects[i])) {
                this.indexAll(projects[i]);
            }
            ++i;
        }
    }
}

