/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.matching;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.search.IMatchLocatorParser;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.core.search.matching.PatternLocator;
import org.eclipse.dltk.core.search.matching.PossibleMatch;
import org.eclipse.dltk.internal.core.search.matching.MatchingNodeSet;

public abstract class MatchLocatorParser
implements IMatchLocatorParser {
    private MatchLocator matchLocator;
    private PatternLocator patternLocator;
    private MatchingNodeSet nodeSet;

    public ModuleDeclaration parse(PossibleMatch possibleMatch) {
        ModuleDeclaration module = SourceParserUtil.getModuleDeclaration((ISourceModule)possibleMatch.getModelElement(), null);
        return module;
    }

    public void parseBodies(ModuleDeclaration unit) {
        block2: {
            try {
                unit.traverse(this.getMatchVisitor());
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public void setNodeSet(MatchingNodeSet nodeSet) {
        this.nodeSet = nodeSet;
    }

    protected MatchingNodeSet getNodeSet() {
        return this.nodeSet;
    }

    protected MatchLocatorParser(MatchLocator locator) {
        this.matchLocator = locator;
        this.patternLocator = locator.patternLocator;
    }

    protected MatchLocator getMatchLocator() {
        return this.matchLocator;
    }

    protected PatternLocator getPatternLocator() {
        return this.patternLocator;
    }

    public MethodDeclaration processMethod(MethodDeclaration m) {
        return m;
    }

    public TypeDeclaration processType(TypeDeclaration t) {
        return t;
    }

    protected void processStatement(ASTNode node, PatternLocator locator) {
    }

    protected MatchVisitor getMatchVisitor() {
        return new MatchVisitor();
    }

    protected class MatchVisitor
    extends ASTVisitor {
        protected MatchVisitor() {
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            MatchLocatorParser.this.processStatement(node, MatchLocatorParser.this.getPatternLocator());
            return true;
        }

        public boolean visit(MethodDeclaration m) throws Exception {
            MatchLocatorParser.this.getPatternLocator().match(MatchLocatorParser.this.processMethod(m), MatchLocatorParser.this.getNodeSet());
            return true;
        }

        public boolean visit(TypeDeclaration t) throws Exception {
            MatchLocatorParser.this.getPatternLocator().match(MatchLocatorParser.this.processType(t), MatchLocatorParser.this.getNodeSet());
            return true;
        }
    }
}

