/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.preferences;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.preferences.Filter;
import org.eclipse.dltk.debug.ui.preferences.FilterLabelProvider;
import org.eclipse.dltk.debug.ui.preferences.FilterViewerComparator;
import org.eclipse.dltk.debug.ui.preferences.Messages;
import org.eclipse.dltk.debug.ui.preferences.ScriptDebugPreferencesMessages;
import org.eclipse.dltk.debug.ui.preferences.StepFilterManager;
import org.eclipse.dltk.internal.debug.ui.ScriptDebugOptionsManager;
import org.eclipse.dltk.ui.DLTKExecuteExtensionHelper;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ScriptStepFilterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IExecutableExtension {
    public static final String PAGE_ID = "org.eclipse.dltk.debug.ui.ScriptStepFilterPreferencePage";
    private CheckboxTableViewer fTableViewer;
    private Button fUseStepFiltersButton;
    private Button fAddAllButton;
    private Button fAddTypeButton;
    private Button fRemoveFilterButton;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private IDLTKLanguageToolkit fToolkit;

    public ScriptStepFilterPreferencePage() {
        this.setPreferenceStore(DLTKDebugUIPlugin.getDefault().getPreferenceStore());
        this.setTitle(ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_title);
        this.setDescription(ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_description);
    }

    protected Control createContents(Composite parent) {
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808, (int)0, (int)0);
        this.createStepFilterPreferences(composite);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    private void handleFilterViewerKeyPress(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            this.removeFilters();
        }
    }

    private void createStepFilterPreferences(Composite parent) {
        Composite container = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)2, (int)1, (int)1808, (int)0, (int)0);
        this.fUseStepFiltersButton = SWTFactory.createCheckButton((Composite)container, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage__Use_step_filters, null, (boolean)StepFilterManager.isUseStepFilters(this.getPreferenceStore()), (int)2);
        this.fUseStepFiltersButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ScriptStepFilterPreferencePage.this.setPageEnablement(ScriptStepFilterPreferencePage.this.fUseStepFiltersButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        SWTFactory.createLabel((Composite)container, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_Defined_step_fi_lters__8, (int)2);
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)68354);
        this.fTableViewer.getTable().setFont(container.getFont());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.fTableViewer.setComparator((ViewerComparator)new FilterViewerComparator());
        this.fTableViewer.setContentProvider((IContentProvider)new StepFilterContentProvider());
        this.fTableViewer.setInput((Object)this.getAllStoredFilters(false));
        this.fTableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((Filter)event.getElement()).setChecked(event.getChecked());
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    ScriptStepFilterPreferencePage.this.fRemoveFilterButton.setEnabled(false);
                } else {
                    ScriptStepFilterPreferencePage.this.fRemoveFilterButton.setEnabled(true);
                }
            }
        });
        this.fTableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                ScriptStepFilterPreferencePage.this.handleFilterViewerKeyPress(event);
            }
        });
        this.createStepFilterButtons(container);
        this.setPageEnablement(this.fUseStepFiltersButton.getSelection());
    }

    private void initTableState(boolean defaults) {
        Filter[] filters = this.getAllStoredFilters(defaults);
        int i = 0;
        while (i < filters.length) {
            this.fTableViewer.add((Object)filters[i]);
            this.fTableViewer.setChecked((Object)filters[i], filters[i].isChecked());
            ++i;
        }
    }

    protected void setPageEnablement(boolean enabled) {
        this.fAddAllButton.setEnabled(enabled);
        this.fAddTypeButton.setEnabled(enabled);
        this.fDeselectAllButton.setEnabled(enabled);
        this.fSelectAllButton.setEnabled(enabled);
        this.fTableViewer.getTable().setEnabled(enabled);
        this.fRemoveFilterButton.setEnabled(enabled & !this.fTableViewer.getSelection().isEmpty());
    }

    private void createStepFilterButtons(Composite container) {
        this.initializeDialogUnits((Control)container);
        Composite buttonContainer = new Composite(container, 0);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fAddTypeButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_Add__Type____11, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_Choose_a_Java_type_and_add_it_to_step_filters_12, null);
        this.fAddTypeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ScriptStepFilterPreferencePage.this.addType();
            }
        });
        this.fAddAllButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_Add__All____13, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_Choose_a_package_and_add_it_to_step_filters_14, null);
        this.fAddAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ScriptStepFilterPreferencePage.this.addAll();
            }
        });
        this.fRemoveFilterButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage__Remove_15, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_Remove_all_selected_step_filters_16, null);
        this.fRemoveFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ScriptStepFilterPreferencePage.this.removeFilters();
            }
        });
        this.fRemoveFilterButton.setEnabled(false);
        Label separator = new Label(buttonContainer, 0);
        separator.setVisible(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        this.fSelectAllButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage__Select_All_1, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_Selects_all_step_filters_2, null);
        this.fSelectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ScriptStepFilterPreferencePage.this.fTableViewer.setAllChecked(true);
            }
        });
        this.fDeselectAllButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_Deselect_All_3, (String)ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_Deselects_all_step_filters_4, null);
        this.fDeselectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ScriptStepFilterPreferencePage.this.fTableViewer.setAllChecked(false);
            }
        });
    }

    private void addType() {
        block3: {
            Object[] types;
            FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)this.fToolkit), 0, this.fToolkit);
            dialog.setMessage(Messages.ScriptStepFilterPreferencePage_search);
            dialog.setInitialPattern("");
            dialog.setTitle(ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_Add_type_to_step_filters_20);
            dialog.setMessage(ScriptDebugPreferencesMessages.ScriptStepFilterPreferencePage_Select_a_type_to_filter_when_stepping_23);
            if (dialog.open() == 0 && (types = dialog.getResult()) != null && types.length > 0) {
                IType type = (IType)types[0];
                try {
                    this.addFilter(type.getTypeQualifiedName("."), true, type.getFlags());
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    private void addAll() {
        block2: {
            IScriptModel model = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            try {
                model.accept(new IModelElementVisitor(){

                    public boolean visit(IModelElement element) {
                        block6: {
                            IProjectFragment fragment;
                            if (element.getElementType() == 2) {
                                IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)element);
                                if (!ScriptStepFilterPreferencePage.this.fToolkit.getNatureId().equals(languageToolkit.getNatureId())) {
                                    return false;
                                }
                            }
                            if (element.getElementType() == 3 && (fragment = (IProjectFragment)element).isExternal()) {
                                return false;
                            }
                            if (element.getElementType() == 7) {
                                IType type = (IType)element;
                                try {
                                    Filter filter = new Filter(type.getTypeQualifiedName("."), true, type.getFlags());
                                    ScriptStepFilterPreferencePage.this.addFilter(filter);
                                }
                                catch (ModelException e) {
                                    if (!DLTKCore.DEBUG) break block6;
                                    e.printStackTrace();
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    protected void removeFilters() {
        this.fTableViewer.remove(((IStructuredSelection)this.fTableViewer.getSelection()).toArray());
    }

    public boolean performOk() {
        StepFilterManager.setUseStepFilters(this.fUseStepFiltersButton.getSelection(), this.getPreferenceStore());
        IPreferenceStore store = this.getPreferenceStore();
        ArrayList<String> active = new ArrayList<String>();
        ArrayList<String> inactive = new ArrayList<String>();
        String name = "";
        Filter[] filters = this.getAllFiltersFromTable();
        int i = 0;
        while (i < filters.length) {
            name = filters[i].getName();
            String modifiers = ":" + Integer.toString(filters[i].getModifiers());
            if (filters[i].isChecked()) {
                active.add(String.valueOf(name) + modifiers);
            } else {
                inactive.add(String.valueOf(name) + modifiers);
            }
            ++i;
        }
        String pref = ScriptDebugOptionsManager.serializeList(active.toArray(new String[active.size()]));
        store.setValue("org.eclipse.dltk.debug.ui.preference_active_filters_list", pref);
        pref = ScriptDebugOptionsManager.serializeList(inactive.toArray(new String[inactive.size()]));
        store.setValue("org.eclipse.dltk.debug.ui.preference_inactive_filters_list", pref);
        return super.performOk();
    }

    protected void performDefaults() {
        boolean stepenabled = DebugUITools.isUseStepFilters();
        this.fUseStepFiltersButton.setSelection(stepenabled);
        this.setPageEnablement(stepenabled);
        this.fTableViewer.getTable().removeAll();
        this.initTableState(true);
        super.performDefaults();
    }

    protected void addFilter(String filter, boolean checked, int modifiers) {
        if (filter != null) {
            Filter f = new Filter(filter, checked, modifiers);
            this.fTableViewer.add((Object)f);
            this.fTableViewer.setChecked((Object)f, checked);
        }
    }

    protected void addFilter(Filter filter) {
        if (filter != null) {
            Filter[] allFiltersFromTable = this.getAllFiltersFromTable();
            int i = 0;
            while (i < allFiltersFromTable.length) {
                if (filter.equals(allFiltersFromTable[i])) {
                    return;
                }
                ++i;
            }
            this.fTableViewer.add((Object)filter);
            this.fTableViewer.setChecked((Object)filter, filter.isChecked());
        }
    }

    protected Filter[] getAllFiltersFromTable() {
        TableItem[] items = this.fTableViewer.getTable().getItems();
        Filter[] filters = new Filter[items.length];
        int i = 0;
        while (i < items.length) {
            filters[i] = (Filter)items[i].getData();
            filters[i].setChecked(items[i].getChecked());
            ++i;
        }
        return filters;
    }

    protected Filter[] getAllStoredFilters(boolean defaults) {
        String[] split;
        String[] inactivefilters;
        String[] activefilters;
        Filter[] filters = null;
        IPreferenceStore store = this.getPreferenceStore();
        if (defaults) {
            activefilters = ScriptDebugOptionsManager.parseList(store.getDefaultString("org.eclipse.dltk.debug.ui.preference_active_filters_list"));
            inactivefilters = ScriptDebugOptionsManager.parseList(store.getDefaultString("org.eclipse.dltk.debug.ui.preference_inactive_filters_list"));
        } else {
            activefilters = ScriptDebugOptionsManager.parseList(store.getString("org.eclipse.dltk.debug.ui.preference_active_filters_list"));
            inactivefilters = ScriptDebugOptionsManager.parseList(store.getString("org.eclipse.dltk.debug.ui.preference_inactive_filters_list"));
        }
        filters = new Filter[activefilters.length + inactivefilters.length];
        int i = 0;
        while (i < activefilters.length) {
            split = activefilters[i].split(":");
            filters[i] = split.length == 1 ? new Filter(split[0], true, 0) : new Filter(split[0], true, new Integer(split[1]));
            ++i;
        }
        i = 0;
        while (i < inactivefilters.length) {
            split = inactivefilters[i].split(":");
            filters[i + activefilters.length] = split.length == 1 ? new Filter(split[0], false, 0) : new Filter(split[0], false, new Integer(split[1]));
            ++i;
        }
        return filters;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fToolkit = DLTKExecuteExtensionHelper.getLanguageToolkit((IConfigurationElement)config, (String)propertyName, (Object)data);
        IDLTKUILanguageToolkit uiToolkit = DLTKUILanguageManager.getLanguageToolkit((String)this.fToolkit.getNatureId());
        IPreferenceStore preferenceStore = uiToolkit.getPreferenceStore();
        Assert.isNotNull((Object)preferenceStore);
        this.setPreferenceStore(preferenceStore);
    }

    class StepFilterContentProvider
    implements IStructuredContentProvider {
        public StepFilterContentProvider() {
            ScriptStepFilterPreferencePage.this.initTableState(false);
        }

        public Object[] getElements(Object inputElement) {
            return ScriptStepFilterPreferencePage.this.getAllFiltersFromTable();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

