/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.core.externalchecker;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.validators.internal.core.ValidatorsCore;
import org.eclipse.dltk.validators.internal.core.externalchecker.CustomWildcard;
import org.eclipse.dltk.validators.internal.core.externalchecker.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ExternalCheckerWildcardManager {
    private static final String STRING = "wildcards";
    private static final String WILDCARD = "wildcard";
    private static final String DESCRIPTION = "description";
    private static final String PATTERN = "pattern";
    private static final String LETTER = "letter";
    public static final String WILDCARDS = "org.eclipse.dltk.validators.core.wildcards";

    public static String getDefaultWildcards() {
        CustomWildcard[] wildcards = new CustomWildcard[]{new CustomWildcard("f", "[\\w]?:?.+", Messages.ExternalCheckerWildcardManager_fileName), new CustomWildcard("m", ".*", Messages.ExternalCheckerWildcardManager_message), new CustomWildcard("n", "[0-9]+", Messages.ExternalCheckerWildcardManager_lineNumber)};
        return ExternalCheckerWildcardManager.rulesToXML(wildcards);
    }

    public static List loadCustomWildcards() {
        ArrayList<CustomWildcard> wildcards;
        block7: {
            wildcards = new ArrayList<CustomWildcard>();
            String preference = ValidatorsCore.getDefault().getPluginPreferences().getString(WILDCARDS);
            if (DLTKCore.DEBUG) {
                System.out.println(preference);
            }
            if (preference != "") {
                try {
                    DocumentBuilderFactory factorryr = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factorryr.newDocumentBuilder();
                    Document doc = builder.parse(new InputSource(new StringReader(preference)));
                    Element docElement = doc.getDocumentElement();
                    if (!docElement.getNodeName().equalsIgnoreCase(STRING)) {
                        return wildcards;
                    }
                    NodeList nlist = docElement.getChildNodes();
                    int i = 0;
                    while (i < nlist.getLength()) {
                        Element element;
                        Node node = nlist.item(i);
                        short type = node.getNodeType();
                        if (type == 1 && (element = (Element)node).getNodeName().equalsIgnoreCase(WILDCARD)) {
                            String name = element.getAttribute(LETTER);
                            String value = element.getAttribute(PATTERN);
                            String descr = element.getAttribute(DESCRIPTION);
                            CustomWildcard wcard = new CustomWildcard(name, value, descr);
                            wildcards.add(wcard);
                        }
                        ++i;
                    }
                }
                catch (Exception x) {
                    if (!DLTKCore.DEBUG) break block7;
                    System.out.println(x.toString());
                }
            }
        }
        return wildcards;
    }

    public static void storeWildcards(CustomWildcard[] customWildcards) {
        String xmlString = ExternalCheckerWildcardManager.rulesToXML(customWildcards);
        ValidatorsCore.getDefault().getPluginPreferences().setValue(WILDCARDS, xmlString);
        ValidatorsCore.getDefault().savePluginPreferences();
    }

    private static String rulesToXML(CustomWildcard[] customWildcards) throws TransformerFactoryConfigurationError {
        String xmlString;
        block4: {
            xmlString = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                Element root = document.createElement(STRING);
                document.appendChild(root);
                int i = 0;
                while (i < customWildcards.length) {
                    Element wildcard = document.createElement(WILDCARD);
                    String name = customWildcards[i].getLetter();
                    String value = customWildcards[i].getSpattern();
                    String description = customWildcards[i].getDescription();
                    wildcard.setAttribute(LETTER, name);
                    wildcard.setAttribute(PATTERN, value);
                    wildcard.setAttribute(DESCRIPTION, description);
                    root.appendChild(wildcard);
                    ++i;
                }
                TransformerFactory tfactory = TransformerFactory.newInstance();
                Transformer trannsformer = tfactory.newTransformer();
                trannsformer.setOutputProperty("omit-xml-declaration", "yes");
                trannsformer.setOutputProperty("indent", "yes");
                StringWriter sw = new StringWriter();
                StreamResult result = new StreamResult(sw);
                DOMSource source = new DOMSource(document);
                trannsformer.transform(source, result);
                xmlString = sw.toString();
                if (DLTKCore.DEBUG) {
                    System.out.println(xmlString);
                }
            }
            catch (Exception x) {
                if (!DLTKCore.DEBUG) break block4;
                System.out.println(x.toString());
            }
        }
        return xmlString;
    }
}

