/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.core;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.debug.core.IDbgpService;
import org.eclipse.dltk.debug.core.Messages;
import org.eclipse.dltk.internal.debug.core.model.DbgpService;
import org.eclipse.dltk.internal.debug.core.model.HotCodeReplaceManager;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugTarget;
import org.osgi.framework.BundleContext;

public class DLTKDebugPlugin
extends Plugin {
    private static final String LOCALHOST = "127.0.0.1";
    public static final String PLUGIN_ID = "org.eclipse.dltk.debug";
    public static final int INTERNAL_ERROR = 120;
    private static DLTKDebugPlugin fgPlugin;
    private DbgpService dbgpService;

    public static DLTKDebugPlugin getDefault() {
        return fgPlugin;
    }

    public DLTKDebugPlugin() {
        fgPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        HotCodeReplaceManager.getDefault().startup();
    }

    public void stop(BundleContext context) throws Exception {
        HotCodeReplaceManager.getDefault().shutdown();
        super.stop(context);
        if (this.dbgpService != null) {
            this.dbgpService.shutdown();
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        IDebugTarget[] targets = launchManager.getDebugTargets();
        int i = 0;
        while (i < targets.length) {
            IDebugTarget target = targets[i];
            if (target instanceof ScriptDebugTarget) {
                ((ScriptDebugTarget)target).shutdown();
            }
            ++i;
        }
    }

    public synchronized IDbgpService getDbgpService() {
        if (this.dbgpService == null) {
            this.dbgpService = new DbgpService(this.getPreferencePort());
            this.getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)new DbgpServicePreferenceUpdater());
        }
        return this.dbgpService;
    }

    public static void log(Throwable t) {
        Throwable throwable;
        Throwable top = t;
        if (t instanceof DebugException && (throwable = ((DebugException)t).getStatus().getException()) != null) {
            top = throwable;
        }
        DLTKDebugPlugin.log((IStatus)new Status(4, PLUGIN_ID, 120, String.valueOf(Messages.DLTKDebugPlugin_internalErrorLoggedFromDltkDebugPlugin) + top.getMessage(), top));
    }

    public static void log(IStatus status) {
        DLTKDebugPlugin.getDefault().getLog().log(status);
    }

    public static void error(String message, Throwable t) {
        Throwable throwable;
        Throwable top = t;
        if (t instanceof DebugException && (throwable = ((DebugException)t).getStatus().getException()) != null) {
            top = throwable;
        }
        DLTKDebugPlugin.log((IStatus)new Status(4, PLUGIN_ID, 120, message, top));
    }

    private int getPreferencePort() {
        return this.getPluginPreferences().getInt("dbgp_port");
    }

    public String getBindAddress() {
        String address = this.getPluginPreferences().getString("dbgp_bind_address");
        if ("autodetect".equals(address) || address.trim().length() == 0) {
            String[] ipAddresses = DLTKDebugPlugin.getLocalAddresses();
            address = ipAddresses.length > 0 ? ipAddresses[0] : LOCALHOST;
        }
        return address;
    }

    public static String[] getLocalAddresses() {
        HashSet<String> addresses;
        block7: {
            addresses = new HashSet<String>();
            try {
                Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
                while (netInterfaces.hasMoreElements()) {
                    NetworkInterface ni = netInterfaces.nextElement();
                    if (ni.getName().startsWith("vmnet") || ni.getDisplayName() != null && ni.getDisplayName().indexOf("VMware") != -1) continue;
                    Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        InetAddress ip = inetAddresses.nextElement();
                        if (ip.isLoopbackAddress() || ip.getAddress().length != 4) continue;
                        addresses.add(ip.getHostAddress());
                    }
                }
                if (addresses.isEmpty()) {
                    addresses.add(InetAddress.getLocalHost().getHostAddress());
                }
            }
            catch (SocketException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (UnknownHostException e) {
                if (!DLTKCore.DEBUG) break block7;
                e.printStackTrace();
            }
        }
        return addresses.toArray(new String[addresses.size()]);
    }

    private class DbgpServicePreferenceUpdater
    implements Preferences.IPropertyChangeListener {
        private DbgpServicePreferenceUpdater() {
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("dbgp_port".equals(property) && DLTKDebugPlugin.this.dbgpService != null) {
                DLTKDebugPlugin.this.dbgpService.restart(DLTKDebugPlugin.this.getPreferencePort());
            }
        }
    }
}

