/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.dbgp.IDbgpContinuationHandler;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.model.IScriptDebugThreadConfigurator;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.internal.debug.core.model.DebugEventHelper;
import org.eclipse.dltk.internal.debug.core.model.IScriptStreamProxy;
import org.eclipse.dltk.internal.debug.core.model.IScriptThreadManager;
import org.eclipse.dltk.internal.debug.core.model.IScriptThreadManagerListener;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugTarget;
import org.eclipse.dltk.internal.debug.core.model.ScriptThread;
import org.eclipse.dltk.internal.debug.core.model.operations.DbgpDebugger;

public class ScriptThreadManager
implements IScriptThreadManager {
    private static final boolean DEBUG = DLTKCore.DEBUG;
    private IScriptDebugThreadConfigurator configurator = null;
    private final ListenerList listeners = new ListenerList(1);
    private final List threads = new ArrayList();
    private volatile boolean waitingForThreads = true;
    private final ScriptDebugTarget target;
    private IDbgpContinuationHandler outputListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getThreadBoolean(IThreadBoolean b) {
        List list = this.threads;
        synchronized (list) {
            IScriptThread[] ths = this.getThreads();
            if (ths.length == 0) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= ths.length) {
                    return true;
                }
                if (!b.get(ths[i])) {
                    return false;
                }
                ++i;
            }
        }
    }

    protected void fireThreadAccepted(IScriptThread thread, boolean first) {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IScriptThreadManagerListener)list[i]).threadAccepted(thread, first);
            ++i;
        }
    }

    protected void fireAllThreadsTerminated() {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IScriptThreadManagerListener)list[i]).allThreadsTerminated();
            ++i;
        }
    }

    public void addListener(IScriptThreadManagerListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IScriptThreadManagerListener listener) {
        this.listeners.remove((Object)listener);
    }

    public boolean isWaitingForThreads() {
        return this.waitingForThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasThreads() {
        List list = this.threads;
        synchronized (list) {
            return !this.threads.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IScriptThread[] getThreads() {
        List list = this.threads;
        synchronized (list) {
            return this.threads.toArray(new IScriptThread[this.threads.size()]);
        }
    }

    public ScriptThreadManager(ScriptDebugTarget target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this.target = target;
        this.outputListener = new IDbgpContinuationHandler(){

            public void stderrReceived(String data) {
                IScriptStreamProxy proxy = ScriptThreadManager.this.target.getStreamProxy();
                if (proxy != null) {
                    try {
                        OutputStream err = proxy.getStderr();
                        err.write(data.getBytes(ScriptThreadManager.this.target.getConsoleEncoding()));
                        err.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (DEBUG) {
                    System.out.println("Received (stderr): " + data);
                }
            }

            public void stdoutReceived(String data) {
                IScriptStreamProxy proxy = ScriptThreadManager.this.target.getStreamProxy();
                if (proxy != null) {
                    try {
                        OutputStream out = proxy.getStdout();
                        out.write(data.getBytes(ScriptThreadManager.this.target.getConsoleEncoding()));
                        out.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (DEBUG) {
                    System.out.println("Received (stdout): " + data);
                }
            }
        };
    }

    public void acceptDbgpThread(IDbgpSession session) {
        try {
            DbgpException error = session.getInfo().getError();
            if (error != null) {
                throw error;
            }
            session.configure(this.target.getOptions());
            session.getStreamManager().addListener(this.outputListener);
            ScriptThread thread = new ScriptThread(this.target, session, this);
            this.addThread(thread);
            boolean isFirstThread = this.waitingForThreads;
            this.waitingForThreads = false;
            this.fireThreadAccepted(thread, isFirstThread);
            DebugEventHelper.fireCreateEvent(thread);
            thread.resume();
        }
        catch (Exception e) {
            try {
                this.target.terminate();
            }
            catch (DebugException debugException) {}
            DLTKDebugPlugin.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addThread(ScriptThread thread) {
        List list = this.threads;
        synchronized (list) {
            this.threads.add(thread);
        }
    }

    public void acceptDbgpThreadNotUnavailable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateThread(IScriptThread thread) {
        List list = this.threads;
        synchronized (list) {
            this.threads.remove(thread);
            DebugEventHelper.fireTerminateEvent((IDebugElement)thread);
            IDbgpSession session = ((ScriptThread)thread).getDbgpSession();
            session.getStreamManager().removeListener(this.outputListener);
            if (!this.hasThreads()) {
                this.fireAllThreadsTerminated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canTerminate() {
        List list = this.threads;
        synchronized (list) {
            IScriptThread[] ths = this.getThreads();
            if (ths.length == 0) {
                return this.waitingForThreads;
                {
                }
            }
            int i = 0;
            while (true) {
                if (i >= ths.length) {
                    return true;
                }
                if (!ths[i].canTerminate()) {
                    return false;
                }
                ++i;
            }
        }
    }

    public boolean isTerminated() {
        if (!this.hasThreads()) {
            return !this.isWaitingForThreads();
        }
        return this.getThreadBoolean(new IThreadBoolean(){

            public boolean get(IThread thread) {
                return thread.isTerminated();
            }
        });
    }

    public void terminate() throws DebugException {
        this.target.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTerminationRequest() throws DebugException {
        List list = this.threads;
        synchronized (list) {
            IScriptThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                threads[i].sendTerminationRequest();
                ++i;
            }
            this.waitingForThreads = false;
        }
    }

    public boolean canResume() {
        return this.getThreadBoolean(new IThreadBoolean(){

            public boolean get(IThread thread) {
                return thread.canResume();
            }
        });
    }

    public boolean canSuspend() {
        return this.getThreadBoolean(new IThreadBoolean(){

            public boolean get(IThread thread) {
                return thread.canSuspend();
            }
        });
    }

    public boolean isSuspended() {
        return this.getThreadBoolean(new IThreadBoolean(){

            public boolean get(IThread thread) {
                return thread.isSuspended();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws DebugException {
        List list = this.threads;
        synchronized (list) {
            IScriptThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                threads[i].resume();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws DebugException {
        List list = this.threads;
        synchronized (list) {
            IScriptThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                threads[i].suspend();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshThreads() {
        List list = this.threads;
        synchronized (list) {
            IScriptThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                threads[i].updateStackFrames();
                ++i;
            }
        }
    }

    public void setScriptThreadConfigurator(IScriptDebugThreadConfigurator configurator) {
        this.configurator = configurator;
    }

    public void configureThread(DbgpDebugger engine, ScriptThread scriptThread) {
        if (this.configurator != null) {
            this.configurator.configureThread(engine, scriptThread);
        }
    }

    private static interface IThreadBoolean {
        public boolean get(IThread var1);
    }
}

