/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.ui.wizards.Messages;

public class LinkedProjectModel {
    private final IEnvironment environment;
    private final IPath location;
    private final List folders = new ArrayList();

    public LinkedProjectModel(IEnvironment environment2, IPath location2) {
        this.environment = environment2;
        this.location = location2;
    }

    public IEnvironment getEnvironment() {
        return this.environment;
    }

    public IPath getLocation() {
        return this.location;
    }

    public boolean matches(IEnvironment oEnvironment, IPath oLocation) {
        return LinkedProjectModel.equals(this.environment, oEnvironment) && LinkedProjectModel.equals(this.location, oLocation);
    }

    private static boolean equals(Object a, Object b) {
        if (a != null) {
            return a.equals(b);
        }
        return b == null;
    }

    public ProjectFolder[] getFolders() {
        return this.folders.toArray(new ProjectFolder[this.folders.size()]);
    }

    public void addFolder(ProjectFolder projectFolder) {
        this.folders.add(projectFolder);
    }

    public ProjectFolder findFolder(IPath path) {
        for (ProjectFolder folder : this.folders) {
            if (!path.equals((Object)folder.path)) continue;
            return folder;
        }
        return null;
    }

    public void removeFolder(ProjectFolder projectFolder) {
        this.folders.remove(projectFolder);
    }

    public static interface IFolderProvider {
        public ProjectFolder[] getFolders();
    }

    public static class ProjectFolder {
        public static final int KIND_SOURCE = 0;
        public static final int KIND_RESOURCE = 1;
        public static final int KIND_EXTERNAL = 2;
        private int kind;
        private IPath path;
        private String localFolderName;

        public static String describeKind(int kind) {
            switch (kind) {
                case 0: {
                    return Messages.ProjectFolder_kind_sourceFolder;
                }
                case 1: {
                    return Messages.ProjectFolder_kind_folder;
                }
                case 2: {
                    return Messages.ProjectFolder_kind_libraryFolder;
                }
            }
            return String.valueOf(Messages.ProjectFolder_kind_other) + Integer.toString(kind);
        }

        public static int countLinked(ProjectFolder[] folders) {
            int result = 0;
            int i = 0;
            while (i < folders.length) {
                ProjectFolder folder = folders[i];
                if (folder.getKind() == 0 || folder.getKind() == 1) {
                    ++result;
                }
                ++i;
            }
            return result;
        }

        public int getKind() {
            return this.kind;
        }

        public void setKind(int kind) {
            this.kind = kind;
        }

        public IPath getPath() {
            return this.path;
        }

        public void setPath(IPath path) {
            this.path = path;
        }

        public String getLocalFolderName() {
            return this.localFolderName;
        }

        public void setLocalFolderName(String localFolderName) {
            this.localFolderName = localFolderName;
        }

        public boolean isEmptyLocalFolderName() {
            return this.localFolderName == null || this.localFolderName.length() == 0;
        }

        public static boolean isValidKind(int kind) {
            return kind == 0 || kind == 2 || kind == 1;
        }
    }
}

