/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.tcl.internal.ui.wizards.TclProjectCreationWizard;
import org.eclipse.dltk.tcl.internal.ui.wizards.TclWizardMessages;
import org.eclipse.dltk.ui.dialogs.IProjectTemplate;
import org.eclipse.dltk.ui.dialogs.IProjectTemplateOperation;
import org.eclipse.dltk.ui.wizards.ProjectWizardFirstPage;
import org.eclipse.dltk.utils.LazyExtensionManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

final class TclProjectWizardFirstPage
extends ProjectWizardFirstPage {
    public TclProjectWizardFirstPage() {
        this.setTitle(TclWizardMessages.ProjectCreationWizardFirstPage_title);
        this.setDescription(TclWizardMessages.ProjectCreationWizardFirstPage_description);
    }

    protected ProjectWizardFirstPage.IInterpreterGroup createInterpreterGroup(Composite parent) {
        return new TclInterpreterGroup(parent);
    }

    protected boolean interpeterRequired() {
        return false;
    }

    protected ProjectWizardFirstPage.LocationGroup createLocationGroup() {
        return new TclLocationGroup();
    }

    protected IProjectTemplateOperation getProjectTemplateOperation() {
        return ((TclLocationGroup)this.fLocationGroup).getSelectedTemplateOperation();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProjectTemplateDescriptor
    extends LazyExtensionManager.Descriptor<IProjectTemplate> {
        final String nature;
        final String name;
        final String browseButton;

        public ProjectTemplateDescriptor(TclProjectTemplateManager manager, IConfigurationElement configurationElement) {
            super((LazyExtensionManager)manager, configurationElement);
            this.nature = configurationElement.getAttribute("nature");
            this.name = configurationElement.getAttribute("name");
            this.browseButton = configurationElement.getAttribute("browseButton");
        }
    }

    final class TclInterpreterGroup
    extends ProjectWizardFirstPage.AbstractInterpreterGroup {
        public TclInterpreterGroup(Composite composite) {
            super((ProjectWizardFirstPage)TclProjectWizardFirstPage.this, composite);
        }

        protected String getCurrentLanguageNature() {
            return "org.eclipse.dltk.tcl.core.nature";
        }

        protected String getIntereprtersPreferencePageId() {
            return "org.eclipse.dltk.tcl.preferences.interpreters";
        }
    }

    private class TclLocationGroup
    extends ProjectWizardFirstPage.LocationGroup {
        private final List<TclProjectTemplateEntry> fOptions;

        public TclLocationGroup() {
            super((ProjectWizardFirstPage)TclProjectWizardFirstPage.this);
            this.fOptions = new ArrayList<TclProjectTemplateEntry>();
            TclProjectTemplateManager manager = new TclProjectTemplateManager();
            Iterator i = manager.descriptorIterator();
            while (i.hasNext()) {
                ProjectTemplateDescriptor d = (ProjectTemplateDescriptor)((Object)i.next());
                TclProjectTemplateEntry entry = new TclProjectTemplateEntry(d);
                entry.fLinkRadio.setDialogFieldListener((IDialogFieldListener)this);
                this.fOptions.add(entry);
            }
        }

        protected void createControls(Group group, int numColumns) {
            super.createControls(group, numColumns);
            for (TclProjectTemplateEntry entry : this.fOptions) {
                entry.createControls(group);
            }
        }

        protected boolean isModeField(DialogField field, int kind) {
            if (super.isModeField(field, kind)) {
                return true;
            }
            if (kind == 0 || kind == 1) {
                for (TclProjectTemplateEntry entry : this.fOptions) {
                    if (field != entry.fLinkRadio) continue;
                    return true;
                }
            }
            return false;
        }

        public void dialogFieldChanged(DialogField field) {
            super.dialogFieldChanged(field);
            for (TclProjectTemplateEntry entry : this.fOptions) {
                if (field != entry.fLinkRadio) continue;
                entry.fBrowseButton.setEnabled(TclProjectWizardFirstPage.this.isValidProject() && entry.fLinkRadio.isSelected());
                break;
            }
        }

        public boolean isInWorkspace() {
            if (super.isInWorkspace()) {
                return true;
            }
            for (TclProjectTemplateEntry entry : this.fOptions) {
                if (!entry.fLinkRadio.isSelected()) continue;
                return true;
            }
            return false;
        }

        public IStatus validate(IProject handle) {
            IStatus status = super.validate(handle);
            if (status.isOK()) {
                for (TclProjectTemplateEntry entry : this.fOptions) {
                    if (!entry.fLinkRadio.isSelected()) continue;
                    return entry.validate(handle);
                }
            }
            return status;
        }

        IProjectTemplateOperation getSelectedTemplateOperation() {
            for (TclProjectTemplateEntry entry : this.fOptions) {
                if (!entry.fLinkRadio.isSelected()) continue;
                return entry.templateOperation;
            }
            return null;
        }

        public void update(Observable o, Object arg) {
            super.update(o, arg);
            if (o instanceof ProjectWizardFirstPage.NameGroup) {
                for (TclProjectTemplateEntry entry : this.fOptions) {
                    if (!entry.fLinkRadio.isSelected()) continue;
                    entry.fBrowseButton.setEnabled(TclProjectWizardFirstPage.this.isValidProject());
                    break;
                }
            }
        }

        private class TclProjectTemplateEntry {
            final ProjectTemplateDescriptor descriptor;
            final SelectionButtonDialogField fLinkRadio;
            Button fBrowseButton;
            private IProjectTemplateOperation templateOperation;

            public TclProjectTemplateEntry(ProjectTemplateDescriptor descriptor) {
                this.descriptor = descriptor;
                this.fLinkRadio = new SelectionButtonDialogField(16);
                this.fLinkRadio.setLabelText(descriptor.name);
            }

            public void createControls(Group group) {
                this.fLinkRadio.doFillIntoGrid((Composite)group, 2);
                this.fBrowseButton = new Button((Composite)group, 8);
                this.fBrowseButton.setFont(group.getFont());
                this.fBrowseButton.setText(this.descriptor.browseButton);
                this.fBrowseButton.setEnabled(this.fLinkRadio.isSelected());
                this.fBrowseButton.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        TclProjectTemplateEntry.this.doLink();
                    }

                    public void widgetSelected(SelectionEvent e) {
                        TclProjectTemplateEntry.this.doLink();
                    }
                });
                this.fBrowseButton.setLayoutData((Object)StringButtonDialogField.gridDataForButton((Button)this.fBrowseButton, (int)1));
            }

            protected void doLink() {
                IProjectTemplate projectTemplate = (IProjectTemplate)this.descriptor.get();
                if (projectTemplate != null) {
                    IProject project = this.acquireProject();
                    try {
                        IProjectTemplateOperation operation = projectTemplate.configure(project, this.templateOperation, TclProjectWizardFirstPage.this.getShell());
                        if (operation != null) {
                            this.templateOperation = operation;
                            TclLocationGroup.this.fireEvent();
                        }
                    }
                    finally {
                        this.releaseProject(project);
                    }
                    TclLocationGroup.this.fireEvent();
                }
            }

            private IProject acquireProject() {
                return ((TclProjectCreationWizard)((TclLocationGroup)TclLocationGroup.this).TclProjectWizardFirstPage.this.getWizard()).fSecondPage.acquireProject();
            }

            private void releaseProject(IProject project) {
                ((TclProjectCreationWizard)((TclLocationGroup)TclLocationGroup.this).TclProjectWizardFirstPage.this.getWizard()).fSecondPage.releaseProject();
            }

            public IStatus validate(IProject handle) {
                IProjectTemplate projectTemplate = (IProjectTemplate)this.descriptor.get();
                if (projectTemplate != null) {
                    return projectTemplate.validate(this.templateOperation);
                }
                return Status.OK_STATUS;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TclProjectTemplateManager
    extends LazyExtensionManager<IProjectTemplate> {
        public TclProjectTemplateManager() {
            super("org.eclipse.dltk.ui.projectTemplate");
        }

        protected boolean isValidDescriptor(LazyExtensionManager.Descriptor<IProjectTemplate> descriptor) {
            String natureId = ((ProjectTemplateDescriptor)descriptor).nature;
            return natureId == null || "org.eclipse.dltk.tcl.core.nature".equals(natureId);
        }

        protected LazyExtensionManager.Descriptor<IProjectTemplate> createDescriptor(IConfigurationElement confElement) {
            return new ProjectTemplateDescriptor(this, confElement);
        }
    }
}

