/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.dltk.core.IPreferencesLookupDelegate;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.dbgp.DbgpSessionIdGenerator;
import org.eclipse.dltk.debug.core.DLTKDebugLaunchConstants;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.IDbgpService;
import org.eclipse.dltk.debug.core.ScriptDebugManager;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptDebugThreadConfigurator;
import org.eclipse.dltk.internal.debug.core.model.DebugEventHelper;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugTarget;
import org.eclipse.dltk.internal.launching.InterpreterMessages;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;
import org.eclipse.dltk.launching.AbstractInterpreterRunner;
import org.eclipse.dltk.launching.DebugSessionAcceptor;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.launching.debug.DbgpConnectionConfig;
import org.eclipse.dltk.launching.debug.DebuggingEngineManager;
import org.eclipse.dltk.launching.debug.IDebuggingEngine;

public abstract class DebuggingEngineRunner
extends AbstractInterpreterRunner {
    public static final String LAUNCH_ATTR_DEBUGGING_ENGINE_ID = "debugging_engine_id";
    public static final String OVERRIDE_EXE = "OVERRIDE_EXE";

    protected String getSessionId(ILaunchConfiguration configuration) throws CoreException {
        return DbgpSessionIdGenerator.generate();
    }

    protected final IScriptDebugTarget addDebugTarget(ILaunch launch, IDbgpService dbgpService) throws CoreException {
        return null;
    }

    protected IScriptDebugTarget createDebugTarget(ILaunch launch, IDbgpService dbgpService) throws CoreException {
        return new ScriptDebugTarget(this.getDebugModelId(), dbgpService, this.getSessionId(launch.getLaunchConfiguration()), launch, null);
    }

    public DebuggingEngineRunner(IInterpreterInstall install) {
        super(install);
    }

    protected void initializeLaunch(ILaunch launch, InterpreterConfig config, PreferencesLookupDelegate delegate) throws CoreException {
        IDbgpService service = DLTKDebugPlugin.getDefault().getDbgpService();
        if (!service.available()) {
            this.abort(InterpreterMessages.errDbgpServiceNotAvailable, null);
        }
        IScriptDebugTarget target = this.createDebugTarget(launch, service);
        launch.addDebugTarget((IDebugTarget)target);
        IScriptDebugThreadConfigurator configurator = this.createThreadConfigurator(launch.getLaunchConfiguration());
        if (configurator != null) {
            ((ScriptDebugTarget)target).setScriptDebugThreadConfigurator(configurator);
        }
        String qualifier = this.getDebugPreferenceQualifier();
        target.toggleGlobalVariables(delegate.getBoolean(qualifier, this.showGlobalVarsPreferenceKey()));
        target.toggleClassVariables(delegate.getBoolean(qualifier, this.showClassVarsPreferenceKey()));
        target.toggleLocalVariables(delegate.getBoolean(qualifier, this.showLocalVarsPreferenceKey()));
        if (DLTKDebugLaunchConstants.isDebugConsole((ILaunch)launch)) {
            launch.setAttribute("org.eclipse.debug.core.capture_output", "false");
        }
        launch.setAttribute(LAUNCH_ATTR_DEBUGGING_ENGINE_ID, this.getDebuggingEngineId());
        DbgpConnectionConfig.save(config, this.getBindAddress(), service.getPort(), target.getSessionId());
    }

    private String getBindAddress() {
        return DLTKDebugPlugin.getDefault().getBindAddress();
    }

    protected final InterpreterConfig addEngineConfig(InterpreterConfig config, PreferencesLookupDelegate delegate) {
        return null;
    }

    protected abstract InterpreterConfig addEngineConfig(InterpreterConfig var1, PreferencesLookupDelegate var2, ILaunch var3) throws CoreException;

    public void run(InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(InterpreterMessages.DebuggingEngineRunner_launching, 4);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            try {
                PreferencesLookupDelegate delegate = this.createPreferencesLookupDelegate(launch);
                this.initializeLaunch(launch, config, delegate);
                ScriptDebugTarget target = (ScriptDebugTarget)launch.getDebugTarget();
                DebugSessionAcceptor acceptor = new DebugSessionAcceptor(target, monitor);
                try {
                    monitor.worked(1);
                    target.setProcess(this.startProcess(config, launch, monitor, delegate));
                    monitor.worked(1);
                    this.waitDebuggerConnected(launch, acceptor);
                }
                finally {
                    acceptor.disposeStatusHandler();
                }
            }
            catch (CoreException e) {
                launch.terminate();
                throw e;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected IProcess startProcess(InterpreterConfig config, ILaunch launch, IProgressMonitor monitor, PreferencesLookupDelegate delegate) throws CoreException {
        InterpreterConfig newConfig = this.addEngineConfig(config, delegate, launch);
        IProcess process = null;
        try {
            DebugEventHelper.fireExtendedEvent((Object)newConfig, (int)1);
            monitor.subTask(InterpreterMessages.DebuggingEngineRunner_running);
            process = this.rawRun(launch, newConfig);
        }
        catch (CoreException e) {
            this.abort(InterpreterMessages.errDebuggingEngineNotStarted, e);
        }
        return process;
    }

    protected String[] renderCommandLine(InterpreterConfig config) {
        String exe = (String)config.getProperty(OVERRIDE_EXE);
        if (exe != null) {
            return config.renderCommandLine(this.getInstall().getEnvironment(), exe);
        }
        return config.renderCommandLine(this.getInstall());
    }

    protected IScriptDebugThreadConfigurator createThreadConfigurator() {
        return null;
    }

    protected IScriptDebugThreadConfigurator createThreadConfigurator(ILaunchConfiguration configuration) {
        return this.createThreadConfigurator();
    }

    protected void waitDebuggerConnected(IProcess process, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ScriptDebugTarget target = (ScriptDebugTarget)launch.getDebugTarget();
        this.waitDebuggerConnected(launch, new DebugSessionAcceptor(target, monitor));
    }

    protected void waitDebuggerConnected(ILaunch launch, DebugSessionAcceptor acceptor) throws CoreException {
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        int timeout = LaunchConfigurationUtils.getConnectionTimeout(configuration, DLTKDebugPlugin.getConnectionTimeout());
        if (!acceptor.waitConnection(timeout)) {
            launch.terminate();
            return;
        }
        if (!acceptor.waitInitialized(3600000)) {
            launch.terminate();
            this.abort(InterpreterMessages.errDebuggingEngineNotInitialized, null);
        }
    }

    public String getDebugModelId() {
        return ScriptDebugManager.getInstance().getDebugModelByNature(this.getInstall().getNatureId());
    }

    public IDebuggingEngine getDebuggingEngine() {
        return DebuggingEngineManager.getInstance().getDebuggingEngine(this.getDebuggingEngineId());
    }

    protected String showGlobalVarsPreferenceKey() {
        return "dbgp_show_scope_global";
    }

    protected String showClassVarsPreferenceKey() {
        return "dbgp_show_scope_class";
    }

    protected String showLocalVarsPreferenceKey() {
        return "dbgp_show_scope_local";
    }

    protected abstract String getDebuggingEngineId();

    protected PreferencesLookupDelegate createPreferencesLookupDelegate(ILaunch launch) throws CoreException {
        IScriptProject sProject = ScriptRuntime.getScriptProject(launch.getLaunchConfiguration());
        return new PreferencesLookupDelegate(sProject.getProject());
    }

    protected abstract String getDebugPreferenceQualifier();

    protected abstract String getDebuggingEnginePreferenceQualifier();

    protected boolean isLoggingEnabled(IPreferencesLookupDelegate delegate) {
        return true;
    }

    protected abstract String getLogFileNamePreferenceKey();

    protected String getLogFileName(PreferencesLookupDelegate delegate, String sessionId) {
        IEnvironment env;
        if (!this.isLoggingEnabled((IPreferencesLookupDelegate)delegate)) {
            return null;
        }
        String qualifier = this.getDebuggingEnginePreferenceQualifier();
        String keyValue = delegate.getString(qualifier, this.getLogFileNamePreferenceKey());
        Map logFileNames = EnvironmentPathUtils.decodePaths((String)keyValue);
        String pathString = (String)logFileNames.get(env = this.getInstall().getEnvironment());
        if (pathString != null && pathString.length() > 0) {
            return pathString;
        }
        return null;
    }
}

