/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching.sourcelookup;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.debug.core.model.ScriptStackFrame;
import org.eclipse.dltk.internal.launching.IPathEquality;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;
import org.eclipse.dltk.internal.launching.PathEqualityUtils;
import org.eclipse.dltk.launching.sourcelookup.DBGPSourceModule;

public class ScriptSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    public String getSourceName(Object object) throws CoreException {
        if (object instanceof ScriptStackFrame) {
            ScriptStackFrame frame = (ScriptStackFrame)object;
            URI uri = frame.getSourceURI();
            if ("unknown".equalsIgnoreCase(uri.getScheme())) {
                return null;
            }
            String path = uri.getPath();
            if (path.length() == 0) {
                return null;
            }
            String root = this.getProjectRoot();
            if (path.startsWith(root) && path.charAt(root.length()) == '/') {
                return path.substring(root.length() + 1);
            }
            IFile[] files = ScriptSourceLookupParticipant.getWorkspaceRoot().findFilesForLocation((IPath)new Path(path));
            IProject project = LaunchConfigurationUtils.getProject(this.getDirector().getLaunchConfiguration());
            int i = 0;
            while (i < files.length) {
                IFile file = files[i];
                if (file.exists() && file.getProject().equals((Object)project)) {
                    return file.getProjectRelativePath().toString();
                }
                ++i;
            }
            return path;
        }
        return null;
    }

    private IEnvironment getEnvironment() {
        IProject project = LaunchConfigurationUtils.getProject(this.getDirector().getLaunchConfiguration());
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        return EnvironmentManager.getEnvironment((IModelElement)scriptProject);
    }

    protected String getProjectRoot() throws CoreException {
        IProject project = LaunchConfigurationUtils.getProject(this.getDirector().getLaunchConfiguration());
        return project.getLocationURI().getPath();
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        Object[] elements = super.findSourceElements(object);
        if (elements != null && elements.length > 0) {
            return elements;
        }
        if (object instanceof ScriptStackFrame) {
            ScriptStackFrame frame = (ScriptStackFrame)object;
            URI uri = frame.getSourceURI();
            if ("unknown".equalsIgnoreCase(uri.getScheme())) {
                return null;
            }
            String path = uri.getPath();
            if (path == null || path.length() == 0) {
                return null;
            }
            Path pathObj = new Path(path);
            if (pathObj.isEmpty()) {
                return null;
            }
            ILaunchConfiguration launchConfiguration = this.getDirector().getLaunchConfiguration();
            IProject project = LaunchConfigurationUtils.getProject(launchConfiguration);
            ScriptProject scriptProject = (ScriptProject)DLTKCore.create((IProject)project);
            IFileHandle file = this.getEnvironment().getFile((IPath)pathObj);
            if (file.exists()) {
                Object[] workspaceFiles = ScriptSourceLookupParticipant.getWorkspaceRoot().findFilesForLocationURI(file.toURI());
                if (workspaceFiles.length != 0 && workspaceFiles[0].exists()) {
                    return workspaceFiles;
                }
                ExternalSourceModuleFinder finder = new ExternalSourceModuleFinder(file.getFullPath());
                scriptProject.accept((IModelElementVisitor)finder);
                if (finder.isFound()) {
                    return finder.getResult();
                }
            }
            return new Object[]{new DBGPSourceModule(scriptProject, path, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, frame)};
        }
        return null;
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private final class ExternalSourceModuleFinder
    implements IModelElementVisitor {
        private final IPath fileFullPath;
        private final IPathEquality pathEquality = PathEqualityUtils.getInstance();
        private final ISourceModule[] result = new ISourceModule[1];

        private ExternalSourceModuleFinder(IPath fileFullPath) {
            this.fileFullPath = fileFullPath;
        }

        public boolean visit(IModelElement element) {
            IProjectFragment fragment;
            if (element.getElementType() == 3 && !(fragment = (IProjectFragment)element).isExternal()) {
                return false;
            }
            if (element.getElementType() == 5) {
                ISourceModule module = (ISourceModule)element;
                IPath modulePath = module.getPath();
                if (module instanceof ExternalSourceModule) {
                    IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)element);
                    ExternalSourceModule mdl = (ExternalSourceModule)module;
                    modulePath = mdl.getFullPath();
                    if (!EnvironmentPathUtils.isFull((IPath)modulePath)) {
                        modulePath = EnvironmentPathUtils.getFullPath((IEnvironment)environment, (IPath)modulePath);
                    }
                }
                if (this.pathEquality.equals(this.fileFullPath, modulePath)) {
                    this.result[0] = module;
                }
                return false;
            }
            return true;
        }

        public boolean isFound() {
            return this.result[0] != null;
        }

        public Object[] getResult() {
            return this.result;
        }
    }
}

