/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.launching;

import java.io.IOException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.launching.AbstractInterpreterInstallType;
import org.eclipse.dltk.internal.launching.InterpreterMessages;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.ScriptLaunchUtil;
import org.eclipse.dltk.ruby.internal.launching.RubyGenericInstall;
import org.eclipse.dltk.ruby.launching.RubyLaunchingPlugin;
import org.osgi.framework.Bundle;

public class RubyGenericInstallType
extends AbstractInterpreterInstallType {
    private static final String CORRECT_INTERPRETER_PATTERN = "#DLTK INTERPRETER TEST:5";
    private static final String INSTALL_TYPE_NAME = "Generic Ruby";
    private static final String[] INTERPRETER_NAMES = new String[]{"ruby", "rubyw", "ruby18", "ruby19"};
    static /* synthetic */ Class class$0;

    public String getNatureId() {
        return "org.eclipse.dltk.ruby.core.nature";
    }

    public String getName() {
        return INSTALL_TYPE_NAME;
    }

    protected String getPluginId() {
        return "org.eclipse.dltk.ruby.launching";
    }

    protected String[] getPossibleInterpreterNames() {
        return INTERPRETER_NAMES;
    }

    protected IInterpreterInstall doCreateInterpreterInstall(String id) {
        return new RubyGenericInstall((IInterpreterInstallType)this, id);
    }

    protected IPath createPathFile(IDeployment deployment) throws IOException {
        return deployment.add(RubyLaunchingPlugin.getDefault().getBundle(), "scripts/path.rb");
    }

    public IStatus validateInstallLocation(IFileHandle installLocation) {
        if (!installLocation.exists() || !installLocation.isFile()) {
            return this.createStatus(4, InterpreterMessages.errNonExistentOrInvalidInstallLocation, null);
        }
        IEnvironment environment = installLocation.getEnvironment();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.core.environment.IExecutionEnvironment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IExecutionEnvironment executionEnvironment = (IExecutionEnvironment)environment.getAdapter((Class)clazz);
        String output = ScriptLaunchUtil.runEmbeddedScriptReadContent((IExecutionEnvironment)executionEnvironment, (String)"scripts/test.rb", (Bundle)RubyLaunchingPlugin.getDefault().getBundle(), (IFileHandle)installLocation, (IProgressMonitor)new NullProgressMonitor());
        String[] lines = output.split("\\n");
        boolean correct = false;
        int i = 0;
        while (i < lines.length) {
            if (CORRECT_INTERPRETER_PATTERN.equals(lines[i])) {
                correct = true;
            }
            ++i;
        }
        if (correct) {
            return this.createStatus(0, "", null);
        }
        return this.createStatus(4, InterpreterMessages.errNoInterpreterExecutablesFound, null);
    }

    protected String getBuildPathDelimeter() {
        return ";:";
    }

    protected ILog getLog() {
        return RubyLaunchingPlugin.getDefault().getLog();
    }
}

