/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.builtin.IRubyObject;

public class DynamicScope {
    private IRubyObject[] variableValues;
    private StaticScope staticScope;
    private DynamicScope parent;
    private DynamicScope bindingScope;

    public DynamicScope(StaticScope staticScope, DynamicScope parent) {
        int size;
        this.staticScope = staticScope;
        if (parent != null && parent.getStaticScope() == staticScope.getEnclosingScope()) {
            this.parent = parent;
        }
        if ((size = staticScope.getNumberOfVariables()) > 0) {
            this.variableValues = new IRubyObject[size];
        }
    }

    public DynamicScope cloneScope() {
        return new DynamicScope(this.staticScope, this.parent);
    }

    public String[] getAllNamesInScope() {
        return this.staticScope.getAllNamesInScope();
    }

    public IRubyObject[] getValues() {
        return this.variableValues;
    }

    public IRubyObject getValue(int offset, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset, depth - 1);
        }
        return this.variableValues[offset];
    }

    public void setValue(int offset, IRubyObject value, int depth) {
        if (depth > 0) {
            this.parent.setValue(offset, value, depth - 1);
        } else {
            this.variableValues[offset] = value;
        }
    }

    public void setArgValues(IRubyObject[] values, int size) {
        System.arraycopy(values, 0, this.variableValues, 2, size);
    }

    public void getArgValues(IRubyObject[] args, int size) {
        if (this.variableValues != null && args != null && this.variableValues.length >= size + 2) {
            System.arraycopy(this.variableValues, 2, args, 0, size);
        }
    }

    public void growIfNeeded() {
        int dynamicSize;
        int n = dynamicSize = this.variableValues == null ? 0 : this.variableValues.length;
        if (this.staticScope.getNumberOfVariables() > dynamicSize) {
            IRubyObject[] values = new IRubyObject[this.staticScope.getNumberOfVariables()];
            if (dynamicSize > 0) {
                System.arraycopy(this.variableValues, 0, values, 0, dynamicSize);
            }
            this.variableValues = values;
        }
    }

    public void setLastLine(IRubyObject value) {
        int location = this.staticScope.isDefined("$_");
        this.setValue(location & 0xFFFF, value, location >> 16);
    }

    public IRubyObject getLastLine() {
        int location = this.staticScope.isDefined("$_");
        return this.getValue(location & 0xFFFF, location >> 16);
    }

    public void setBackRef(IRubyObject value) {
        int location = this.staticScope.isDefined("$~");
        this.setValue(location & 0xFFFF, value, location >> 16);
    }

    public IRubyObject getBackRef() {
        int location = this.staticScope.isDefined("$~");
        return this.getValue(location & 0xFFFF, location >> 16);
    }

    public DynamicScope getBindingScope() {
        return this.bindingScope;
    }

    public void setBindingScope(DynamicScope bindingScope) {
        this.bindingScope = bindingScope;
    }

    public DynamicScope getNextCapturedScope() {
        return this.parent;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public String toString() {
        return this.toString(new StringBuffer(), "");
    }

    private String toString(StringBuffer buf, String indent) {
        buf.append(indent).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " [");
        int size = this.staticScope.getNumberOfVariables();
        if (size != 0) {
            String[] names = this.staticScope.getVariables();
            int i = 0;
            while (i < size - 1) {
                buf.append(names[i]).append("=");
                if (this.variableValues[i] == null) {
                    buf.append("null");
                } else {
                    buf.append(this.variableValues[i]);
                }
                buf.append(",");
                ++i;
            }
            buf.append(names[size - 1]).append("=");
            if (this.variableValues[size - 1] == null) {
                buf.append("null");
            } else {
                buf.append(this.variableValues[size - 1]);
            }
        }
        buf.append("]");
        if (this.parent != null) {
            buf.append("\n");
            this.parent.toString(buf, String.valueOf(indent) + "  ");
        }
        return buf.toString();
    }
}

