/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.mixin;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.caching.IContentCache;
import org.eclipse.dltk.core.caching.MixinModelProcessor;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.mixin.IMixinParser;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.index.MixinIndex;
import org.eclipse.dltk.core.search.indexing.AbstractIndexer;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.mixin.MixinManager;

public class MixinIndexer
extends AbstractIndexer {
    private final ISourceModule sourceModule;

    public MixinIndexer(SearchDocument document, ISourceModule module) {
        super(document);
        this.sourceModule = module;
    }

    public void indexDocument() {
        boolean performed;
        IDLTKLanguageToolkit toolkit;
        block11: {
            IContentCache coreCache;
            InputStream stream;
            toolkit = this.document.getToolkit();
            if (toolkit == null) {
                toolkit = DLTKLanguageManager.findToolkit((IPath)new Path(this.document.getPath()));
            }
            if (toolkit == null) {
                return;
            }
            performed = false;
            IFileHandle handle = EnvironmentPathUtils.getFile(this.sourceModule);
            if (handle != null && (stream = (coreCache = ModelManager.getModelManager().getCoreCache()).getCacheEntryAttribute(handle, "_smix")) != null) {
                try {
                    MixinIndexRequestor requestor = new MixinIndexRequestor();
                    MixinModelProcessor processor = new MixinModelProcessor(stream, requestor);
                    processor.process();
                    stream.close();
                    performed = true;
                    if (requestor.count == 0) {
                        ((MixinIndex)this.document.getIndex()).addDocumentName(this.document.getContainerRelativePath());
                    }
                }
                catch (IOException e) {
                    performed = false;
                    if (!DLTKCore.DEBUG) break block11;
                    e.printStackTrace();
                }
            }
        }
        if (!performed) {
            try {
                IMixinParser parser = MixinManager.getMixinParser(toolkit.getNatureId());
                if (parser != null) {
                    MixinIndexRequestor requestor = new MixinIndexRequestor();
                    parser.setRequirestor(requestor);
                    parser.parserSourceModule(false, this.sourceModule);
                    if (requestor.count == 0) {
                        ((MixinIndex)this.document.getIndex()).addDocumentName(this.document.getContainerRelativePath());
                    }
                }
            }
            catch (CoreException e) {
                DLTKCore.error("Error in MixinIndexer", e);
            }
        }
    }

    private class MixinIndexRequestor
    implements IMixinRequestor {
        int count = 0;

        private MixinIndexRequestor() {
        }

        public void reportElement(IMixinRequestor.ElementInfo info) {
            if (info.key.length() > 0) {
                MixinIndexer.this.addIndexEntry(MIXIN, info.key.toCharArray());
                ++this.count;
            }
        }
    }
}

