/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.index.EntryResult;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.internal.core.search.matching.DLTKSearchPattern;

public class MethodDeclarationPattern
extends DLTKSearchPattern
implements IIndexConstants {
    public char[] simpleName;
    public char[] pkg;
    public char[][] enclosingTypeNames;
    public char typeSuffix;
    public int modifiers;
    public boolean secondary = false;
    public char[][] parameterNames;
    protected static char[][] CATEGORIES = new char[][]{METHOD_DECL};

    public static char[] createIndexKey(int modifiers, char[] methodName, String[] parameterNames, char[] packageName, char[][] enclosingTypeNames) {
        int itsLength;
        int length;
        int i;
        int typeNameLength = methodName == null ? 0 : methodName.length;
        int parameterNamesLength = 0;
        if (parameterNames != null) {
            int i2 = 0;
            int length2 = parameterNames.length;
            while (i2 < length2) {
                parameterNamesLength += parameterNames[i2].length();
                if (++i2 >= length2) continue;
                ++parameterNamesLength;
            }
        }
        int packageLength = packageName == null ? 0 : packageName.length;
        int enclosingNamesLength = 0;
        if (enclosingTypeNames != null) {
            int i3 = 0;
            int length3 = enclosingTypeNames.length;
            while (i3 < length3) {
                enclosingNamesLength += enclosingTypeNames[i3].length;
                if (++i3 >= length3) continue;
                ++enclosingNamesLength;
            }
        }
        int resultLength = typeNameLength + parameterNamesLength + packageLength + enclosingNamesLength + 6;
        char[] result = new char[resultLength];
        int pos = 0;
        if (typeNameLength > 0) {
            System.arraycopy(methodName, 0, result, pos, typeNameLength);
            pos += typeNameLength;
        }
        result[pos++] = 123;
        if (parameterNames != null && parameterNamesLength > 0) {
            i = 0;
            length = parameterNames.length;
            while (i < length) {
                char[] parameterName = parameterNames[i].toCharArray();
                itsLength = parameterName.length;
                System.arraycopy(parameterName, 0, result, pos, itsLength);
                pos += itsLength;
                if (++i >= length) continue;
                result[pos++] = 44;
            }
        }
        result[pos++] = 123;
        if (packageLength > 0) {
            System.arraycopy(packageName, 0, result, pos, packageLength);
            pos += packageLength;
        }
        result[pos++] = 123;
        if (enclosingTypeNames != null && enclosingNamesLength > 0) {
            i = 0;
            length = enclosingTypeNames.length;
            while (i < length) {
                char[] enclosingName = enclosingTypeNames[i];
                itsLength = enclosingName.length;
                System.arraycopy(enclosingName, 0, result, pos, itsLength);
                pos += itsLength;
                if (++i >= length) continue;
                result[pos++] = 36;
            }
        }
        result[pos++] = 123;
        result[pos++] = (char)modifiers;
        result[pos] = (char)(modifiers >> 16);
        return result;
    }

    public MethodDeclarationPattern(char[] simpleName, int matchRule, IDLTKLanguageToolkit toolkit) {
        this(matchRule, toolkit);
        this.simpleName = this.isCaseSensitive() || this.isCamelCase() ? simpleName : CharOperation.toLowerCase(simpleName);
    }

    public MethodDeclarationPattern(char[][] enclosingTypeNames, char[] simpleName, int matchRule, IDLTKLanguageToolkit toolkit) {
        this(simpleName, matchRule, toolkit);
        this.enclosingTypeNames = enclosingTypeNames;
    }

    MethodDeclarationPattern(int matchRule, IDLTKLanguageToolkit toolkit) {
        super(2048, matchRule, toolkit);
    }

    public void decodeIndexKey(char[] key) {
        int start;
        int slash = CharOperation.indexOf('{', key, 0);
        this.simpleName = CharOperation.subarray(key, 0, slash);
        this.parameterNames = key[start = ++slash] == '{' ? CharOperation.NO_CHAR_CHAR : (start == (slash = CharOperation.indexOf('{', key, start)) ? CharOperation.NO_CHAR_CHAR : CharOperation.splitOn(',', key, start, slash));
        if (key[start = ++slash] == '{') {
            this.pkg = CharOperation.NO_CHAR;
        } else {
            slash = CharOperation.indexOf('{', key, start);
            this.pkg = internedPackageNames.add(CharOperation.subarray(key, start, slash));
        }
        int last = key.length - 1;
        boolean bl = this.secondary = key[last] == 'S';
        if (this.secondary) {
            last -= 2;
        }
        this.modifiers = last > 0 ? key[last - 1] + (key[last] << 16) : 0;
        this.decodeModifiers();
        start = slash + 1;
        this.enclosingTypeNames = start == (last -= 2) ? CharOperation.NO_CHAR_CHAR : (last == start + 1 && key[start] == '0' ? ONE_ZERO_CHAR : CharOperation.splitOn('$', key, start, last));
    }

    protected void decodeModifiers() {
        this.typeSuffix = (char)67;
    }

    public SearchPattern getBlankPattern() {
        return new MethodDeclarationPattern(8, this.getToolkit());
    }

    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        MethodDeclarationPattern pattern = (MethodDeclarationPattern)decodedPattern;
        if (!this.matchesName(this.simpleName, pattern.simpleName)) {
            return false;
        }
        return this.enclosingTypeNames == null || pattern.enclosingTypeNames != null && pattern.enclosingTypeNames.length != 0 && this.matchesName(this.enclosingTypeNames[this.enclosingTypeNames.length - 1], pattern.enclosingTypeNames[pattern.enclosingTypeNames.length - 1]);
    }

    public EntryResult[] queryIn(Index index) throws IOException {
        char[] key = this.simpleName;
        int matchRule = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 1: {
                break;
            }
            case 0: {
                if (this.isCamelCase) break;
                matchRule &= 0xFFFFFFFF;
                matchRule |= 1;
                key = CharOperation.append(this.simpleName, '{');
                break;
            }
            case 2: {
                if (this.simpleName[this.simpleName.length - 1] == '*') break;
                key = CharOperation.concat(this.simpleName, ONE_STAR, '{');
                break;
            }
        }
        return index.query(this.getIndexCategories(), key, matchRule);
    }

    protected StringBuffer print(StringBuffer output) {
        output.append("MethodDeclarationPattern: ");
        output.append("name<");
        if (this.simpleName != null) {
            output.append(this.simpleName);
        } else {
            output.append("*");
        }
        output.append(">");
        return super.print(output);
    }
}

