/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.caching;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.core.caching.AbstractDataLoader;
import org.eclipse.dltk.core.caching.IStructureConstants;

public class StructureModelProcessor
extends AbstractDataLoader
implements IStructureConstants {
    private ISourceElementRequestor requestor;

    public StructureModelProcessor(InputStream stream, ISourceElementRequestor requestor) throws IOException {
        super(stream);
        this.requestor = requestor;
    }

    public void perform() throws IOException {
        this.readStrings();
        this.readData();
    }

    private void readData() {
        try {
            while (true) {
                int tag = this.in.readInt();
                switch (tag) {
                    case 0: {
                        this.acceptFieldReference();
                        break;
                    }
                    case 1: {
                        this.acceptMethodReference();
                        break;
                    }
                    case 2: {
                        this.acceptPackage();
                        break;
                    }
                    case 3: {
                        this.acceptTypeReference1();
                        break;
                    }
                    case 4: {
                        this.acceptTypeReference2();
                        break;
                    }
                    case 5: {
                        this.enterField();
                        break;
                    }
                    case 6: {
                        this.enterFieldCheckDuplicates();
                        break;
                    }
                    case 7: {
                        this.enterFieldWithParentType();
                        break;
                    }
                    case 8: {
                        this.enterMethod();
                        break;
                    }
                    case 9: {
                        this.enterMethodRemoveSame();
                        break;
                    }
                    case 10: {
                        this.enterMethodWithParentType();
                        break;
                    }
                    case 11: {
                        this.enterModule();
                        break;
                    }
                    case 12: {
                        this.enterModuleRoot();
                        break;
                    }
                    case 13: {
                        this.enterType();
                        break;
                    }
                    case 14: {
                        this.enterTypeAppend();
                        break;
                    }
                    case 15: {
                        this.exitField();
                        break;
                    }
                    case 16: {
                        this.exitMethod();
                        break;
                    }
                    case 17: {
                        this.exitModule();
                        break;
                    }
                    case 18: {
                        this.exitModuleRoot();
                        break;
                    }
                    case 19: {
                        this.exitType();
                    }
                }
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {}
    }

    private char[] readDataString() throws IOException {
        String text = this.readString();
        if (text == null) {
            return null;
        }
        return text.toCharArray();
    }

    private char[][] readDataStrings() throws IOException {
        int size = this.in.readInt();
        if (size == 0) {
            return null;
        }
        char[][] result = new char[size][];
        int i = 0;
        while (i < size) {
            result[i] = this.readDataString();
            ++i;
        }
        return result;
    }

    private String[] readDataStringsStr() throws IOException {
        int size = this.in.readInt();
        if (size == 0) {
            return null;
        }
        String[] result = new String[size];
        int i = 0;
        while (i < size) {
            result[i] = this.readString();
            ++i;
        }
        return result;
    }

    public void acceptFieldReference() {
        try {
            char[] fieldName = this.readDataString();
            int sourcePosition = this.in.readInt();
            this.requestor.acceptFieldReference(fieldName, sourcePosition);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void acceptMethodReference() {
        try {
            char[] methodName = this.readDataString();
            int argCount = this.in.readInt();
            int sourcePosition = this.in.readInt();
            int sourceEndPosition = this.in.readInt();
            this.requestor.acceptMethodReference(methodName, argCount, sourcePosition, sourceEndPosition);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void acceptPackage() {
        try {
            char[] name = this.readDataString();
            int declarationStart = this.in.readInt();
            int declarationEnd = this.in.readInt();
            this.requestor.acceptPackage(declarationStart, declarationEnd, name);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void acceptTypeReference1() {
        try {
            char[][] typeName = this.readDataStrings();
            int sourceStart = this.in.readInt();
            int sourceEnd = this.in.readInt();
            this.requestor.acceptTypeReference(typeName, sourceStart, sourceEnd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void acceptTypeReference2() {
        try {
            char[] typeName = this.readDataString();
            int sourcePosition = this.in.readInt();
            this.requestor.acceptTypeReference(typeName, sourcePosition);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void enterField() {
        try {
            ISourceElementRequestor.FieldInfo info = new ISourceElementRequestor.FieldInfo();
            this.readFieldInfo(info);
            this.requestor.enterField(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readFieldInfo(ISourceElementRequestor.FieldInfo info) throws IOException {
        this.readElementInfo(info);
    }

    private void readMethodInfo(ISourceElementRequestor.MethodInfo info) throws IOException {
        this.readElementInfo(info);
        info.parameterNames = this.readDataStringsStr();
        info.parameterInitializers = this.readDataStringsStr();
        info.exceptionTypes = this.readDataStringsStr();
        info.isConstructor = this.in.readBoolean();
    }

    private void readTypeInfo(ISourceElementRequestor.TypeInfo info) throws IOException {
        this.readElementInfo(info);
        info.superclasses = this.readDataStringsStr();
    }

    private void readElementInfo(ISourceElementRequestor.ElementInfo info) throws IOException {
        info.name = this.readString();
        info.modifiers = this.in.readInt();
        info.nameSourceStart = this.in.readInt();
        info.nameSourceEnd = this.in.readInt();
        info.declarationStart = this.in.readInt();
    }

    public boolean enterFieldCheckDuplicates() {
        try {
            ISourceElementRequestor.FieldInfo info = new ISourceElementRequestor.FieldInfo();
            this.readFieldInfo(info);
            boolean result = this.in.readBoolean();
            this.requestor.enterFieldCheckDuplicates(info);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean enterFieldWithParentType() {
        boolean result = false;
        try {
            ISourceElementRequestor.FieldInfo info = new ISourceElementRequestor.FieldInfo();
            this.readFieldInfo(info);
            String parentName = this.readString();
            String delimiter = this.readString();
            this.in.readBoolean();
            this.requestor.enterFieldWithParentType(info, parentName, delimiter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void enterMethod() {
        try {
            ISourceElementRequestor.MethodInfo info = new ISourceElementRequestor.MethodInfo();
            this.readMethodInfo(info);
            this.requestor.enterMethod(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void enterMethodRemoveSame() {
        try {
            ISourceElementRequestor.MethodInfo info = new ISourceElementRequestor.MethodInfo();
            this.readMethodInfo(info);
            this.requestor.enterMethodRemoveSame(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean enterMethodWithParentType() {
        boolean result = false;
        try {
            ISourceElementRequestor.MethodInfo info = new ISourceElementRequestor.MethodInfo();
            this.readMethodInfo(info);
            String parentName = this.readString();
            String delimiter = this.readString();
            result = this.requestor.enterMethodWithParentType(info, parentName, delimiter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void enterModule() {
        this.requestor.enterModule();
    }

    public void enterModuleRoot() {
        this.requestor.enterModuleRoot();
    }

    public void enterType() {
        try {
            ISourceElementRequestor.TypeInfo info = new ISourceElementRequestor.TypeInfo();
            this.readTypeInfo(info);
            this.requestor.enterType(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean enterTypeAppend() {
        try {
            String fullName = this.readString();
            String delimiter = this.readString();
            return this.requestor.enterTypeAppend(fullName, delimiter);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void exitField() {
        try {
            this.requestor.exitField(this.in.readInt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exitMethod() {
        try {
            this.requestor.exitMethod(this.in.readInt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exitModule() {
        try {
            this.requestor.exitModule(this.in.readInt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exitModuleRoot() {
        this.requestor.exitModuleRoot();
    }

    public void exitType() {
        try {
            this.requestor.exitType(this.in.readInt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

