/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.DeltaProcessor;
import org.eclipse.dltk.internal.core.Messages;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelElementDelta;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.SourceModule;

public abstract class ModelOperation
implements IWorkspaceRunnable,
IProgressMonitor {
    protected static final int APPEND = 1;
    protected static final int REMOVEALL_APPEND = 2;
    protected static final int KEEP_EXISTING = 3;
    protected static boolean POST_ACTION_VERBOSE;
    public static final String HAS_MODIFIED_RESOURCE_ATTR = "hasModifiedResource";
    public static final String TRUE = "true";
    protected static ThreadLocal operationStacks;
    protected IPostAction[] actions;
    protected int actionsStart = 0;
    protected int actionsEnd = -1;
    protected HashMap attributes;
    protected IModelElement[] elementsToProcess;
    protected IModelElement[] parentElements;
    protected IModelElement[] resultElements = ModelElement.NO_ELEMENTS;
    protected IProgressMonitor progressMonitor = null;
    protected boolean force = false;
    protected boolean isNested = false;

    static {
        operationStacks = new ThreadLocal();
    }

    protected ModelOperation() {
    }

    protected ModelOperation(IModelElement element) {
        this.elementsToProcess = new IModelElement[]{element};
    }

    protected ModelOperation(IModelElement[] elements) {
        this.elementsToProcess = elements;
    }

    protected ModelOperation(IModelElement[] elements, boolean force) {
        this.elementsToProcess = elements;
        this.force = force;
    }

    protected ModelOperation(IModelElement[] elementsToProcess, IModelElement[] parentElements, boolean force) {
        this.elementsToProcess = elementsToProcess;
        this.parentElements = parentElements;
        this.force = force;
    }

    protected void addAction(IPostAction action) {
        int length = this.actions.length;
        if (length == ++this.actionsEnd) {
            this.actions = new IPostAction[length * 2];
            System.arraycopy(this.actions, 0, this.actions, 0, length);
        }
        this.actions[this.actionsEnd] = action;
    }

    protected void addDelta(IModelElementDelta delta) {
        ModelManager.getModelManager().getDeltaProcessor().registerModelDelta(delta);
    }

    protected void addReconcileDelta(ISourceModule workingCopy, IModelElementDelta delta) {
        HashMap reconcileDeltas = ModelManager.getModelManager().getDeltaProcessor().reconcileDeltas;
        ModelElementDelta previousDelta = (ModelElementDelta)reconcileDeltas.get(workingCopy);
        if (previousDelta != null) {
            IModelElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                ModelElementDelta child = (ModelElementDelta)children[i];
                previousDelta.insertDeltaTree(child.getElement(), child);
                ++i;
            }
        } else {
            reconcileDeltas.put(workingCopy, delta);
        }
    }

    public void beginTask(String name, int totalWork) {
        if (this.progressMonitor != null) {
            this.progressMonitor.beginTask(name, totalWork);
        }
    }

    protected boolean canModifyRoots() {
        return false;
    }

    protected void checkCanceled() {
        if (this.isCanceled()) {
            throw new OperationCanceledException(Messages.ModelOperation_operationCancelled);
        }
    }

    protected IModelStatus commonVerify() {
        if (this.elementsToProcess == null || this.elementsToProcess.length == 0) {
            return new ModelStatus(968);
        }
        int i = 0;
        while (i < this.elementsToProcess.length) {
            if (this.elementsToProcess[i] == null) {
                return new ModelStatus(968);
            }
            ++i;
        }
        return ModelStatus.VERIFIED_OK;
    }

    protected void copyResources(IResource[] resources, IPath destinationPath) throws ModelException {
        IProgressMonitor subProgressMonitor = this.getSubProgressMonitor(resources.length);
        IWorkspace workspace = resources[0].getWorkspace();
        try {
            workspace.copy(resources, destinationPath, false, subProgressMonitor);
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    protected void createFile(IContainer folder, String name, InputStream contents, boolean forceFlag) throws ModelException {
        IFile file = folder.getFile((IPath)new Path(name));
        try {
            file.create(contents, forceFlag ? 3 : 2, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    protected void createFolder(IContainer parentFolder, String name, boolean forceFlag) throws ModelException {
        IFolder folder = parentFolder.getFolder((IPath)new Path(name));
        try {
            folder.create(forceFlag ? 3 : 2, true, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    protected void deleteEmptyScriptFolder(IScriptFolder fragment, boolean forceFlag, IResource rootResource) throws ModelException {
        IContainer resource = (IContainer)fragment.getResource();
        try {
            resource.delete(forceFlag ? 3 : 2, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
            while (resource instanceof IFolder) {
                if ((resource = resource.getParent()).equals((Object)rootResource) || resource.members().length != 0) continue;
                resource.delete(forceFlag ? 3 : 2, this.getSubProgressMonitor(1));
                this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
            }
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    protected void deleteResource(IResource resource, int flags) throws ModelException {
        try {
            resource.delete(flags, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    protected void deleteResources(IResource[] resources, boolean forceFlag) throws ModelException {
        if (resources == null || resources.length == 0) {
            return;
        }
        IProgressMonitor subProgressMonitor = this.getSubProgressMonitor(resources.length);
        IWorkspace workspace = resources[0].getWorkspace();
        try {
            workspace.delete(resources, forceFlag ? 3 : 2, subProgressMonitor);
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    public void done() {
        if (this.progressMonitor != null) {
            this.progressMonitor.done();
        }
    }

    protected boolean equalsOneOf(IPath path, IPath[] otherPaths) {
        int i = 0;
        int length = otherPaths.length;
        while (i < length) {
            if (path.equals((Object)otherPaths[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void executeNestedOperation(ModelOperation operation, int subWorkAmount) throws ModelException {
        IModelStatus status = operation.verify();
        if (!status.isOK()) {
            throw new ModelException(status);
        }
        IProgressMonitor subProgressMonitor = this.getSubProgressMonitor(subWorkAmount);
        try {
            operation.setNested(true);
            operation.run(subProgressMonitor);
        }
        catch (CoreException ce) {
            Throwable e;
            if (ce instanceof ModelException) {
                throw (ModelException)ce;
            }
            if (ce.getStatus().getCode() == 76 && (e = ce.getStatus().getException()) instanceof ModelException) {
                throw (ModelException)((Object)e);
            }
            throw new ModelException(ce);
        }
    }

    protected abstract void executeOperation() throws ModelException;

    protected int firstActionWithID(String id, int start) {
        int i = start;
        while (i <= this.actionsEnd) {
            if (this.actions[i].getID().equals(id)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected Object getAttribute(Object key) {
        ArrayList stack = this.getCurrentOperationStack();
        if (stack.size() == 0) {
            return null;
        }
        ModelOperation topLevelOp = (ModelOperation)stack.get(0);
        if (topLevelOp.attributes == null) {
            return null;
        }
        return topLevelOp.attributes.get(key);
    }

    protected ArrayList getCurrentOperationStack() {
        ArrayList stack = (ArrayList)operationStacks.get();
        if (stack == null) {
            stack = new ArrayList();
            operationStacks.set(stack);
        }
        return stack;
    }

    protected IModelElement getElementToProcess() {
        if (this.elementsToProcess == null || this.elementsToProcess.length == 0) {
            return null;
        }
        return this.elementsToProcess[0];
    }

    public IScriptModel getModel() {
        if (this.elementsToProcess == null || this.elementsToProcess.length == 0) {
            return this.getParentElement().getModel();
        }
        return this.elementsToProcess[0].getModel();
    }

    protected IPath[] getNestedFolders(IProjectFragment root) throws ModelException {
        IPath rootPath = root.getPath();
        IBuildpathEntry[] buildpath = root.getScriptProject().getRawBuildpath();
        int length = buildpath.length;
        IPath[] result = new IPath[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            IPath path = buildpath[i].getPath();
            if (rootPath.isPrefixOf(path) && !rootPath.equals((Object)path)) {
                result[index++] = path;
            }
            ++i;
        }
        if (index < length) {
            IPath[] iPathArray = result;
            result = new IPath[index];
            System.arraycopy(iPathArray, 0, result, 0, index);
        }
        return result;
    }

    protected IModelElement getParentElement() {
        if (this.parentElements == null || this.parentElements.length == 0) {
            return null;
        }
        return this.parentElements[0];
    }

    protected IModelElement[] getParentElements() {
        return this.parentElements;
    }

    public IModelElement[] getResultElements() {
        return this.resultElements;
    }

    protected ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IProgressMonitor getSubProgressMonitor(int workAmount) {
        SubProgressMonitor sub = null;
        if (this.progressMonitor != null) {
            sub = new SubProgressMonitor(this.progressMonitor, workAmount, 4);
        }
        return sub;
    }

    public boolean hasModifiedResource() {
        return !this.isReadOnly() && this.getAttribute(HAS_MODIFIED_RESOURCE_ATTR) == TRUE;
    }

    public void internalWorked(double work) {
        if (this.progressMonitor != null) {
            this.progressMonitor.internalWorked(work);
        }
    }

    public boolean isCanceled() {
        if (this.progressMonitor != null) {
            return this.progressMonitor.isCanceled();
        }
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected boolean isTopLevelOperation() {
        ArrayList stack = this.getCurrentOperationStack();
        return stack.size() > 0 && stack.get(0) == this;
    }

    protected void moveResources(IResource[] resources, IPath destinationPath) throws ModelException {
        SubProgressMonitor subProgressMonitor = null;
        if (this.progressMonitor != null) {
            subProgressMonitor = new SubProgressMonitor(this.progressMonitor, resources.length, 4);
        }
        IWorkspace workspace = resources[0].getWorkspace();
        try {
            workspace.move(resources, destinationPath, false, (IProgressMonitor)subProgressMonitor);
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    public ModelElementDelta newModelElementDelta() {
        return new ModelElementDelta(this.getModel());
    }

    protected ModelOperation popOperation() {
        ArrayList stack = this.getCurrentOperationStack();
        int size = stack.size();
        if (size > 0) {
            if (size == 1) {
                operationStacks.set(null);
            }
            return (ModelOperation)stack.remove(size - 1);
        }
        return null;
    }

    protected void postAction(IPostAction action, int insertionMode) {
        if (POST_ACTION_VERBOSE) {
            System.out.print("(" + Thread.currentThread() + ") [ModelOperation.postAction(IPostAction, int)] Posting action " + action.getID());
            switch (insertionMode) {
                case 2: {
                    System.out.println(" (REMOVEALL_APPEND)");
                    break;
                }
                case 3: {
                    System.out.println(" (KEEP_EXISTING)");
                    break;
                }
                case 1: {
                    System.out.println(" (APPEND)");
                }
            }
        }
        ModelOperation topLevelOp = (ModelOperation)this.getCurrentOperationStack().get(0);
        IPostAction[] postActions = topLevelOp.actions;
        if (postActions == null) {
            topLevelOp.actions = postActions = new IPostAction[1];
            postActions[0] = action;
            topLevelOp.actionsEnd = 0;
        } else {
            String id = action.getID();
            switch (insertionMode) {
                case 2: {
                    int index = this.actionsStart - 1;
                    while ((index = topLevelOp.firstActionWithID(id, index + 1)) >= 0) {
                        System.arraycopy(postActions, index + 1, postActions, index, topLevelOp.actionsEnd - index);
                        postActions[topLevelOp.actionsEnd--] = null;
                    }
                    topLevelOp.addAction(action);
                    break;
                }
                case 3: {
                    if (topLevelOp.firstActionWithID(id, 0) >= 0) break;
                    topLevelOp.addAction(action);
                    break;
                }
                case 1: {
                    topLevelOp.addAction(action);
                }
            }
        }
    }

    protected boolean prefixesOneOf(IPath path, IPath[] otherPaths) {
        int i = 0;
        int length = otherPaths.length;
        while (i < length) {
            if (path.isPrefixOf(otherPaths[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void pushOperation(ModelOperation operation) {
        this.getCurrentOperationStack().add(operation);
    }

    protected void removeAllPostAction(String actionID) {
        if (POST_ACTION_VERBOSE) {
            System.out.println("(" + Thread.currentThread() + ") [ModelOperation.removeAllPostAction(String)] Removing actions " + actionID);
        }
        ModelOperation topLevelOp = (ModelOperation)this.getCurrentOperationStack().get(0);
        IPostAction[] postActions = topLevelOp.actions;
        if (postActions == null) {
            return;
        }
        int index = this.actionsStart - 1;
        while ((index = topLevelOp.firstActionWithID(actionID, index + 1)) >= 0) {
            System.arraycopy(postActions, index + 1, postActions, index, topLevelOp.actionsEnd - index);
            postActions[topLevelOp.actionsEnd--] = null;
        }
    }

    protected void removeReconcileDelta(ISourceModule workingCopy) {
        ModelManager.getModelManager().getDeltaProcessor().reconcileDeltas.remove(workingCopy);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        block23: {
            ModelManager manager = ModelManager.getModelManager();
            DeltaProcessor deltaProcessor = manager.getDeltaProcessor();
            int previousDeltaCount = deltaProcessor.modelDeltas.size();
            try {
                this.progressMonitor = monitor;
                this.pushOperation(this);
                try {
                    if (this.canModifyRoots()) {
                        ModelManager.getModelManager().deltaState.initializeRoots();
                    }
                    this.executeOperation();
                }
                catch (Throwable throwable) {
                    if (this.isTopLevelOperation()) {
                        this.runPostActions();
                    }
                    throw throwable;
                }
                if (this.isTopLevelOperation()) {
                    this.runPostActions();
                }
            }
            finally {
                try {
                    deltaProcessor = manager.getDeltaProcessor();
                    int i = previousDeltaCount;
                    int size = deltaProcessor.modelDeltas.size();
                    while (i < size) {
                        deltaProcessor.updateModel((IModelElementDelta)deltaProcessor.modelDeltas.get(i));
                        ++i;
                    }
                    i = 0;
                    int length = this.resultElements.length;
                    while (i < length) {
                        IModelElement element = this.resultElements[i];
                        Openable openable = (Openable)element.getOpenable();
                        if (!(openable instanceof SourceModule) || !((SourceModule)openable).isWorkingCopy()) {
                            ((ModelElement)openable.getParent()).close();
                        }
                        switch (element.getElementType()) {
                            case 3: 
                            case 4: {
                                ((ScriptProject)element.getScriptProject()).resetCaches();
                            }
                        }
                        ++i;
                    }
                    if (!(!this.isTopLevelOperation() || deltaProcessor.modelDeltas.size() <= previousDeltaCount && deltaProcessor.reconcileDeltas.isEmpty() || this.hasModifiedResource())) {
                        deltaProcessor.fire(null, 0);
                    }
                    break block23;
                }
                finally {
                    this.popOperation();
                }
            }
            {
            }
        }
    }

    public void runOperation(IProgressMonitor monitor) throws ModelException {
        IModelStatus status = this.verify();
        if (!status.isOK()) {
            throw new ModelException(status);
        }
        try {
            if (this.isReadOnly()) {
                this.run(monitor);
            } else {
                IWorkspace wc = ResourcesPlugin.getWorkspace();
                wc.run((IWorkspaceRunnable)this, this.getSchedulingRule(), 1, monitor);
            }
        }
        catch (CoreException ce) {
            Throwable e;
            if (ce instanceof ModelException) {
                throw (ModelException)ce;
            }
            if (ce.getStatus().getCode() == 76 && (e = ce.getStatus().getException()) instanceof ModelException) {
                throw (ModelException)((Object)e);
            }
            throw new ModelException(ce);
        }
    }

    protected void runPostActions() throws ModelException {
        while (this.actionsStart <= this.actionsEnd) {
            IPostAction postAction = this.actions[this.actionsStart++];
            if (POST_ACTION_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [ModelOperation.runPostActions()] Running action " + postAction.getID());
            }
            postAction.run();
        }
    }

    protected void setAttribute(Object key, Object attribute) {
        ModelOperation topLevelOp = (ModelOperation)this.getCurrentOperationStack().get(0);
        if (topLevelOp.attributes == null) {
            topLevelOp.attributes = new HashMap();
        }
        topLevelOp.attributes.put(key, attribute);
    }

    public void setCanceled(boolean value) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setCanceled(value);
        }
    }

    protected void setNested(boolean nested) {
        this.isNested = nested;
    }

    public void setTaskName(String name) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setTaskName(name);
        }
    }

    public void subTask(String name) {
        if (this.progressMonitor != null) {
            this.progressMonitor.subTask(name);
        }
    }

    protected IModelStatus verify() {
        return this.commonVerify();
    }

    public void worked(int work) {
        if (this.progressMonitor != null) {
            this.progressMonitor.worked(work);
            this.checkCanceled();
        }
    }

    protected static interface IPostAction {
        public String getID();

        public void run() throws ModelException;
    }
}

