/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

public class CharArraySequence
implements CharSequence {
    private final char[] buff;
    private final int offset;
    private final int count;

    public CharArraySequence(char[] buff) {
        this(buff, 0, buff.length);
    }

    public CharArraySequence(char[] buff, int count) {
        this(buff, 0, count);
    }

    public CharArraySequence(char[] buff, int offset, int count) {
        this.buff = buff;
        this.offset = offset;
        this.count = count;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.buff[this.offset + index];
    }

    public int length() {
        return this.count;
    }

    public CharSequence subSequence(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > this.count) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException(endIndex - beginIndex);
        }
        return beginIndex == 0 && endIndex == this.count ? this : new CharArraySequence(this.buff, this.offset + beginIndex, endIndex - beginIndex);
    }

    public String toString() {
        return new String(this.buff, this.offset, this.count);
    }
}

